/*
 * Decompiled with CFR 0.152.
 */
package tech.ydb.shaded.google.common.collect;

import tech.ydb.shaded.checkerframework.checker.nullness.qual.Nullable;
import tech.ydb.shaded.google.common.annotations.GwtCompatible;
import tech.ydb.shaded.google.common.base.Preconditions;
import tech.ydb.shaded.google.common.collect.ElementTypesAreNonnullByDefault;
import tech.ydb.shaded.google.common.collect.ImmutableList;
import tech.ydb.shaded.google.common.collect.ImmutableSet;
import tech.ydb.shaded.google.common.collect.Iterators;
import tech.ydb.shaded.google.common.collect.UnmodifiableIterator;
import tech.ydb.shaded.javax.annotation.CheckForNull;

@ElementTypesAreNonnullByDefault
@GwtCompatible(serializable=true, emulated=true)
final class SingletonImmutableSet<E>
extends ImmutableSet<E> {
    final transient E element;

    SingletonImmutableSet(E element) {
        this.element = Preconditions.checkNotNull(element);
    }

    @Override
    public int size() {
        return 1;
    }

    @Override
    public boolean contains(@CheckForNull Object target) {
        return this.element.equals(target);
    }

    @Override
    public UnmodifiableIterator<E> iterator() {
        return Iterators.singletonIterator(this.element);
    }

    @Override
    public ImmutableList<E> asList() {
        return ImmutableList.of(this.element);
    }

    @Override
    boolean isPartialView() {
        return false;
    }

    @Override
    int copyIntoArray(@Nullable Object[] dst, int offset) {
        dst[offset] = this.element;
        return offset + 1;
    }

    @Override
    public final int hashCode() {
        return this.element.hashCode();
    }

    @Override
    public String toString() {
        return '[' + this.element.toString() + ']';
    }
}

