/*
 * Decompiled with CFR 0.152.
 */
package tech.ydb.shaded.google.common.collect;

import java.io.Serializable;
import java.util.Map;
import tech.ydb.shaded.google.common.annotations.GwtCompatible;
import tech.ydb.shaded.google.common.annotations.GwtIncompatible;
import tech.ydb.shaded.google.common.annotations.J2ktIncompatible;
import tech.ydb.shaded.google.common.collect.ElementTypesAreNonnullByDefault;
import tech.ydb.shaded.google.common.collect.ImmutableMap;
import tech.ydb.shaded.google.common.collect.ImmutableSet;
import tech.ydb.shaded.google.common.collect.IndexedImmutableSet;
import tech.ydb.shaded.google.common.collect.UnmodifiableIterator;
import tech.ydb.shaded.javax.annotation.CheckForNull;

@ElementTypesAreNonnullByDefault
@GwtCompatible(emulated=true)
final class ImmutableMapKeySet<K, V>
extends IndexedImmutableSet<K> {
    private final ImmutableMap<K, V> map;

    ImmutableMapKeySet(ImmutableMap<K, V> map) {
        this.map = map;
    }

    @Override
    public int size() {
        return this.map.size();
    }

    @Override
    public UnmodifiableIterator<K> iterator() {
        return this.map.keyIterator();
    }

    @Override
    public boolean contains(@CheckForNull Object object) {
        return this.map.containsKey(object);
    }

    @Override
    K get(int index) {
        return ((Map.Entry)((ImmutableSet)this.map.entrySet()).asList().get(index)).getKey();
    }

    @Override
    boolean isPartialView() {
        return true;
    }

    @Override
    @GwtIncompatible
    Object writeReplace() {
        return new KeySetSerializedForm<K>(this.map);
    }

    @GwtIncompatible
    @J2ktIncompatible
    private static class KeySetSerializedForm<K>
    implements Serializable {
        final ImmutableMap<K, ?> map;
        private static final long serialVersionUID = 0L;

        KeySetSerializedForm(ImmutableMap<K, ?> map) {
            this.map = map;
        }

        Object readResolve() {
            return this.map.keySet();
        }
    }
}

