/*
 * Decompiled with CFR 0.152.
 */
package tech.ydb.shaded.bouncycastle.util;

import java.math.BigInteger;
import java.security.SecureRandom;

public final class BigIntegers {
    public static final BigInteger ZERO = BigInteger.valueOf(0L);
    public static final BigInteger ONE = BigInteger.valueOf(1L);
    private static final BigInteger TWO = BigInteger.valueOf(2L);
    private static final BigInteger THREE = BigInteger.valueOf(3L);
    private static final int MAX_ITERATIONS = 1000;

    public static byte[] asUnsignedByteArray(BigInteger bigInteger) {
        byte[] byArray = bigInteger.toByteArray();
        if (byArray[0] == 0) {
            byte[] byArray2 = new byte[byArray.length - 1];
            System.arraycopy(byArray, 1, byArray2, 0, byArray2.length);
            return byArray2;
        }
        return byArray;
    }

    public static byte[] asUnsignedByteArray(int n, BigInteger bigInteger) {
        byte[] byArray = bigInteger.toByteArray();
        if (byArray.length == n) {
            return byArray;
        }
        int n2 = byArray[0] == 0 ? 1 : 0;
        int n3 = byArray.length - n2;
        if (n3 > n) {
            throw new IllegalArgumentException("standard length exceeded for value");
        }
        byte[] byArray2 = new byte[n];
        System.arraycopy(byArray, n2, byArray2, byArray2.length - n3, n3);
        return byArray2;
    }

    public static BigInteger createRandomInRange(BigInteger bigInteger, BigInteger bigInteger2, SecureRandom secureRandom) {
        int n = bigInteger.compareTo(bigInteger2);
        if (n >= 0) {
            if (n > 0) {
                throw new IllegalArgumentException("'min' may not be greater than 'max'");
            }
            return bigInteger;
        }
        if (bigInteger.bitLength() > bigInteger2.bitLength() / 2) {
            return BigIntegers.createRandomInRange(ZERO, bigInteger2.subtract(bigInteger), secureRandom).add(bigInteger);
        }
        for (int i = 0; i < 1000; ++i) {
            BigInteger bigInteger3 = BigIntegers.createRandomBigInteger(bigInteger2.bitLength(), secureRandom);
            if (bigInteger3.compareTo(bigInteger) < 0 || bigInteger3.compareTo(bigInteger2) > 0) continue;
            return bigInteger3;
        }
        return BigIntegers.createRandomBigInteger(bigInteger2.subtract(bigInteger).bitLength() - 1, secureRandom).add(bigInteger);
    }

    public static BigInteger fromUnsignedByteArray(byte[] byArray) {
        return new BigInteger(1, byArray);
    }

    public static BigInteger fromUnsignedByteArray(byte[] byArray, int n, int n2) {
        byte[] byArray2 = byArray;
        if (n != 0 || n2 != byArray.length) {
            byArray2 = new byte[n2];
            System.arraycopy(byArray, n, byArray2, 0, n2);
        }
        return new BigInteger(1, byArray2);
    }

    public static int getUnsignedByteLength(BigInteger bigInteger) {
        return (bigInteger.bitLength() + 7) / 8;
    }

    public static BigInteger createRandomBigInteger(int n, SecureRandom secureRandom) {
        return new BigInteger(1, BigIntegers.createRandom(n, secureRandom));
    }

    public static BigInteger createRandomPrime(int n, int n2, SecureRandom secureRandom) {
        byte[] byArray;
        BigInteger bigInteger;
        if (n < 2) {
            throw new IllegalArgumentException("bitLength < 2");
        }
        if (n == 2) {
            return secureRandom.nextInt() < 0 ? TWO : THREE;
        }
        do {
            byArray = BigIntegers.createRandom(n, secureRandom);
            int n3 = 8 * byArray.length - n;
            byte by = (byte)(1 << 7 - n3);
            byArray[0] = (byte)(byArray[0] | by);
            int n4 = byArray.length - 1;
            byArray[n4] = (byte)(byArray[n4] | 1);
        } while (!(bigInteger = new BigInteger(1, byArray)).isProbablePrime(n2));
        return bigInteger;
    }

    private static byte[] createRandom(int n, SecureRandom secureRandom) throws IllegalArgumentException {
        if (n < 1) {
            throw new IllegalArgumentException("bitLength must be at least 1");
        }
        int n2 = (n + 7) / 8;
        byte[] byArray = new byte[n2];
        secureRandom.nextBytes(byArray);
        int n3 = 8 * n2 - n;
        byArray[0] = (byte)(byArray[0] & (byte)(255 >>> n3));
        return byArray;
    }
}

