/*
 * Decompiled with CFR 0.152.
 */
package tech.ydb.scheme.impl;

import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import tech.ydb.core.Result;
import tech.ydb.core.Status;
import tech.ydb.core.grpc.GrpcRequestSettings;
import tech.ydb.proto.scheme.SchemeOperationProtos;
import tech.ydb.scheme.SchemeClient;
import tech.ydb.scheme.description.DescribePathResult;
import tech.ydb.scheme.description.ListDirectoryResult;
import tech.ydb.scheme.impl.SchemeClientBuilderImpl;
import tech.ydb.scheme.impl.SchemeRpc;
import tech.ydb.shaded.google.common.base.Splitter;

public class SchemeClientImpl
implements SchemeClient {
    private final SchemeRpc schemeRpc;

    SchemeClientImpl(SchemeClientBuilderImpl builder) {
        this.schemeRpc = builder.schemeRpc;
    }

    public static SchemeClient.Builder newClient(SchemeRpc rpc) {
        return new SchemeClientBuilderImpl(rpc);
    }

    @Override
    public CompletableFuture<Status> makeDirectory(String path) {
        return this.mkdir(path);
    }

    @Override
    public CompletableFuture<Status> makeDirectories(String path) {
        if (path.lastIndexOf(47) < 1) {
            return this.mkdir(path);
        }
        String database = this.schemeRpc.getDatabase();
        if (!database.isEmpty() && path.startsWith(database)) {
            path = path.substring(database.length());
        }
        Iterator<String> it = Splitter.on('/').omitEmptyStrings().split(path).iterator();
        CompletableFuture<Status> future = new CompletableFuture<Status>();
        this.mkdirs(database, it, future);
        return future;
    }

    private void mkdirs(String prefix, Iterator<String> it, CompletableFuture<Status> promise) {
        if (!it.hasNext()) {
            promise.complete(Status.SUCCESS);
            return;
        }
        String path = prefix + '/' + it.next();
        this.mkdir(path).whenComplete((s, e) -> {
            if (e != null) {
                promise.completeExceptionally((Throwable)e);
            } else if (!s.isSuccess() && !prefix.isEmpty()) {
                promise.complete((Status)s);
            } else {
                this.mkdirs(path, it, promise);
            }
        });
    }

    private CompletableFuture<Status> mkdir(String path) {
        SchemeOperationProtos.MakeDirectoryRequest request = SchemeOperationProtos.MakeDirectoryRequest.newBuilder().setPath(path).build();
        GrpcRequestSettings grpcRequestSettings = GrpcRequestSettings.newBuilder().build();
        return this.schemeRpc.makeDirectory(request, grpcRequestSettings);
    }

    @Override
    public CompletableFuture<Status> removeDirectory(String path) {
        SchemeOperationProtos.RemoveDirectoryRequest request = SchemeOperationProtos.RemoveDirectoryRequest.newBuilder().setPath(path).build();
        GrpcRequestSettings grpcRequestSettings = GrpcRequestSettings.newBuilder().build();
        return this.schemeRpc.removeDirectory(request, grpcRequestSettings);
    }

    @Override
    public CompletableFuture<Result<DescribePathResult>> describePath(String path) {
        SchemeOperationProtos.DescribePathRequest request = SchemeOperationProtos.DescribePathRequest.newBuilder().setPath(path).build();
        GrpcRequestSettings grpcRequestSettings = GrpcRequestSettings.newBuilder().build();
        return this.schemeRpc.describePath(request, grpcRequestSettings).thenApply(result -> result.map(DescribePathResult::new));
    }

    @Override
    public CompletableFuture<Result<ListDirectoryResult>> listDirectory(String path) {
        SchemeOperationProtos.ListDirectoryRequest request = SchemeOperationProtos.ListDirectoryRequest.newBuilder().setPath(path).build();
        GrpcRequestSettings grpcRequestSettings = GrpcRequestSettings.newBuilder().build();
        return this.schemeRpc.describeDirectory(request, grpcRequestSettings).thenApply(result -> result.map(ListDirectoryResult::new));
    }

    @Override
    public void close() {
        this.schemeRpc.close();
    }
}

