/*
 * Decompiled with CFR 0.152.
 */
package tech.ydb.scheme;

import java.util.concurrent.CompletableFuture;
import tech.ydb.core.Result;
import tech.ydb.core.Status;
import tech.ydb.core.grpc.GrpcTransport;
import tech.ydb.scheme.description.DescribePathResult;
import tech.ydb.scheme.description.ListDirectoryResult;
import tech.ydb.scheme.impl.GrpcSchemeRpc;
import tech.ydb.scheme.impl.SchemeClientImpl;
import tech.ydb.shaded.javax.annotation.WillNotClose;

public interface SchemeClient
extends AutoCloseable {
    public static Builder newClient(@WillNotClose GrpcTransport transport) {
        return SchemeClientImpl.newClient(GrpcSchemeRpc.useTransport(transport));
    }

    public CompletableFuture<Status> makeDirectory(String var1);

    public CompletableFuture<Status> makeDirectories(String var1);

    public CompletableFuture<Status> removeDirectory(String var1);

    public CompletableFuture<Result<DescribePathResult>> describePath(String var1);

    public CompletableFuture<Result<ListDirectoryResult>> listDirectory(String var1);

    @Override
    public void close();

    public static interface Builder {
        public SchemeClient build();
    }
}

