/*
 * Decompiled with CFR 0.152.
 */
package tech.ydb.jdbc.settings;

import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLEncoder;
import java.sql.DriverPropertyInfo;
import java.sql.SQLException;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import tech.ydb.core.utils.URITools;
import tech.ydb.jdbc.settings.YdbClientProperties;
import tech.ydb.jdbc.settings.YdbConnectionProperties;
import tech.ydb.jdbc.settings.YdbOperationProperties;
import tech.ydb.jdbc.settings.YdbProperty;
import tech.ydb.jdbc.settings.YdbQueryProperties;

public class YdbConfig {
    static final String TOKEN_KEY = "token";
    static final String USERNAME_KEY = "user";
    static final String PASSWORD_KEY = "password";
    static final YdbProperty<Boolean> CACHE_CONNECTIONS_IN_DRIVER = YdbProperty.bool("cacheConnectionsInDriver", "Cache YDB connections in YdbDriver, cached by combination or url and properties", true);
    static final YdbProperty<Integer> PREPARED_STATEMENT_CACHE_SIZE = YdbProperty.integer("preparedStatementCacheQueries", "Specifies the maximum number of entries in per-transport cache of prepared statements. A value of {@code 0} disables the cache.", 256);
    static final YdbProperty<Boolean> USE_QUERY_SERVICE = YdbProperty.bool("useQueryService", "Use QueryService instead of TableService", false);
    static final YdbProperty<Boolean> FULLSCAN_DETECTOR_ENABLED = YdbProperty.bool("jdbcFullScanDetector", "Enable analizator for collecting query stats", false);
    static final YdbProperty<Boolean> TRANSACTION_TRACER = YdbProperty.bool("enableTxTracer", "Enable collecting of transaction execution traces", false);
    private final String url;
    private final String username;
    private final String password;
    private final String safeUrl;
    private final String connectionString;
    private final Properties properties;
    private final boolean isCacheConnectionsInDriver;
    private final int preparedStatementsCacheSize;
    private final boolean useQueryService;
    private final boolean fullScanDetectorEnabled;
    private final boolean txTracerEnabled;

    private YdbConfig(String url, String safeUrl, String connectionString, String username, String password, Properties props) throws SQLException {
        this.url = url;
        this.username = username;
        this.password = password;
        this.safeUrl = safeUrl;
        this.connectionString = connectionString;
        this.properties = props;
        this.isCacheConnectionsInDriver = CACHE_CONNECTIONS_IN_DRIVER.readValue(props).getValue();
        this.preparedStatementsCacheSize = Math.max(0, PREPARED_STATEMENT_CACHE_SIZE.readValue(props).getValue());
        this.useQueryService = USE_QUERY_SERVICE.readValue(props).getValue();
        this.fullScanDetectorEnabled = FULLSCAN_DETECTOR_ENABLED.readValue(props).getValue();
        this.txTracerEnabled = TRANSACTION_TRACER.readValue(props).getValue();
    }

    public Properties getSafeProps() {
        Properties safe = new Properties();
        for (String key : this.properties.stringPropertyNames()) {
            if (YdbConfig.isSensetive(key)) {
                safe.put(key, "***");
                continue;
            }
            safe.put(key, this.properties.get(key));
        }
        return safe;
    }

    public String getConnectionString() {
        return this.connectionString;
    }

    public boolean isCacheConnectionsInDriver() {
        return this.isCacheConnectionsInDriver;
    }

    public int getPreparedStatementsCachecSize() {
        return this.preparedStatementsCacheSize;
    }

    public boolean isUseQueryService() {
        return this.useQueryService;
    }

    public boolean isFullScanDetectorEnabled() {
        return this.fullScanDetectorEnabled;
    }

    public boolean isTxTracedEnabled() {
        return this.txTracerEnabled;
    }

    static boolean isSensetive(String key) {
        return TOKEN_KEY.equalsIgnoreCase(key) || PASSWORD_KEY.equalsIgnoreCase(key);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof YdbConfig)) {
            return false;
        }
        YdbConfig that = (YdbConfig)o;
        return Objects.equals(this.url, that.url) && Objects.equals(this.properties, that.properties);
    }

    public int hashCode() {
        return Objects.hash(this.url, this.properties);
    }

    public String getUrl() {
        return this.url;
    }

    public String getSafeUrl() {
        return this.safeUrl;
    }

    public String getUsername() {
        return this.username;
    }

    String getPassword() {
        return this.password;
    }

    Properties getProperties() {
        return this.properties;
    }

    public DriverPropertyInfo[] toPropertyInfo() throws SQLException {
        return new DriverPropertyInfo[]{CACHE_CONNECTIONS_IN_DRIVER.toInfo(this.properties), PREPARED_STATEMENT_CACHE_SIZE.toInfo(this.properties), USE_QUERY_SERVICE.toInfo(this.properties), YdbConnectionProperties.LOCAL_DATACENTER.toInfo(this.properties), YdbConnectionProperties.USE_SECURE_CONNECTION.toInfo(this.properties), YdbConnectionProperties.SECURE_CONNECTION_CERTIFICATE.toInfo(this.properties), YdbConnectionProperties.TOKEN.toInfo(this.properties), YdbConnectionProperties.SERVICE_ACCOUNT_FILE.toInfo(this.properties), YdbConnectionProperties.USE_METADATA.toInfo(this.properties), YdbConnectionProperties.IAM_ENDPOINT.toInfo(this.properties), YdbConnectionProperties.METADATA_URL.toInfo(this.properties), YdbClientProperties.KEEP_QUERY_TEXT.toInfo(this.properties), YdbClientProperties.SESSION_KEEP_ALIVE_TIME.toInfo(this.properties), YdbClientProperties.SESSION_MAX_IDLE_TIME.toInfo(this.properties), YdbClientProperties.SESSION_POOL_SIZE_MIN.toInfo(this.properties), YdbClientProperties.SESSION_POOL_SIZE_MAX.toInfo(this.properties), YdbOperationProperties.USE_STREAM_RESULT_SETS.toInfo(this.properties), YdbOperationProperties.JOIN_DURATION.toInfo(this.properties), YdbOperationProperties.QUERY_TIMEOUT.toInfo(this.properties), YdbOperationProperties.SCAN_QUERY_TIMEOUT.toInfo(this.properties), YdbOperationProperties.FAIL_ON_TRUNCATED_RESULT.toInfo(this.properties), YdbOperationProperties.SESSION_TIMEOUT.toInfo(this.properties), YdbOperationProperties.DEADLINE_TIMEOUT.toInfo(this.properties), YdbOperationProperties.AUTOCOMMIT.toInfo(this.properties), YdbOperationProperties.TRANSACTION_LEVEL.toInfo(this.properties), YdbOperationProperties.SCHEME_QUERY_TX_MODE.toInfo(this.properties), YdbOperationProperties.SCAN_QUERY_TX_MODE.toInfo(this.properties), YdbOperationProperties.BULK_QUERY_TX_MODE.toInfo(this.properties), YdbQueryProperties.DISABLE_PREPARE_DATAQUERY.toInfo(this.properties), YdbQueryProperties.DISABLE_AUTO_PREPARED_BATCHES.toInfo(this.properties), YdbQueryProperties.DISABLE_DETECT_SQL_OPERATIONS.toInfo(this.properties), YdbQueryProperties.DISABLE_JDBC_PARAMETERS.toInfo(this.properties), YdbQueryProperties.DISABLE_JDBC_PARAMETERS_DECLARE.toInfo(this.properties), YdbQueryProperties.REPLACE_INSERT_TO_UPSERT.toInfo(this.properties), YdbQueryProperties.FORCE_BULK_UPSERT.toInfo(this.properties), YdbQueryProperties.FORCE_SCAN_SELECT.toInfo(this.properties)};
    }

    public static boolean isYdb(String url) {
        return url.startsWith("jdbc:ydb:");
    }

    public static YdbConfig from(String jdbcURL, Properties origin) throws SQLException {
        if (!YdbConfig.isYdb(jdbcURL)) {
            String msg = "[" + jdbcURL + "] is not a YDB URL, must starts from " + "jdbc:ydb:";
            throw new SQLException(msg);
        }
        try {
            String ydbURL;
            String connectionString = ydbURL = jdbcURL.substring("jdbc:ydb:".length());
            String safeURL = ydbURL;
            Properties properties = new Properties();
            String username = null;
            String password = null;
            if (origin != null) {
                properties.putAll((Map<?, ?>)origin);
                username = origin.getProperty(USERNAME_KEY);
                password = origin.getProperty(PASSWORD_KEY);
            }
            if (!ydbURL.isEmpty()) {
                URI url = new URI(ydbURL.contains("://") ? ydbURL : "grpc://" + ydbURL);
                Map<String, List<String>> params = URITools.splitQuery(url);
                String userInfo = url.getUserInfo();
                if (username == null && userInfo != null) {
                    String[] parsed = userInfo.split(":", 2);
                    if (parsed.length > 0) {
                        username = parsed[0];
                    }
                    if (parsed.length > 1) {
                        password = parsed[1];
                    }
                }
                String database = url.getPath();
                for (Map.Entry<String, List<String>> entry : params.entrySet()) {
                    String value = entry.getValue().get(entry.getValue().size() - 1);
                    properties.put(entry.getKey(), value);
                    if (!"database".equalsIgnoreCase(entry.getKey()) || database != null && !database.isEmpty()) continue;
                    database = value.startsWith("/") ? value : "/" + value;
                }
                StringBuilder sb = new StringBuilder();
                sb.append(url.getScheme()).append("://");
                sb.append(url.getHost());
                if (url.getPort() > 0) {
                    sb.append(":").append(url.getPort());
                }
                sb.append(database);
                connectionString = sb.toString();
                if (!params.isEmpty()) {
                    String prefix = "?";
                    for (Map.Entry<String, List<String>> entry : params.entrySet()) {
                        String value = entry.getValue().get(entry.getValue().size() - 1);
                        if (YdbConfig.isSensetive(entry.getKey())) {
                            value = "***";
                        }
                        if (value == null || value.isEmpty()) continue;
                        sb.append(prefix);
                        sb.append(URLEncoder.encode(entry.getKey(), "UTF-8"));
                        sb.append("=");
                        sb.append(URLEncoder.encode(value, "UTF-8"));
                        prefix = "&";
                    }
                }
                safeURL = sb.toString();
            }
            return new YdbConfig(jdbcURL, safeURL, connectionString, username, password, properties);
        }
        catch (UnsupportedEncodingException | RuntimeException | URISyntaxException ex) {
            throw new SQLException(ex.getMessage(), ex);
        }
    }
}

