/*
 * Decompiled with CFR 0.152.
 */
package tech.ydb.jdbc.query.params;

import java.sql.SQLException;
import tech.ydb.jdbc.common.TypeDescription;
import tech.ydb.table.values.OptionalValue;
import tech.ydb.table.values.Type;
import tech.ydb.table.values.Value;

public class ValueFactory {
    private ValueFactory() {
    }

    public static Value<?> readValue(String name, Object value, TypeDescription type) throws SQLException {
        if (value == null) {
            if (type.nullValue() != null) {
                return type.nullValue();
            }
            return type.ydbType().makeOptional().emptyValue();
        }
        if (value instanceof Value) {
            Value ydbValue = (Value)value;
            if (type.isOptional()) {
                if (ydbValue instanceof OptionalValue) {
                    ValueFactory.checkType(name, type.ydbType(), ydbValue.asOptional().getType().getItemType());
                    return ydbValue;
                }
                ValueFactory.checkType(name, type.ydbType(), ydbValue.getType());
                return ydbValue.makeOptional();
            }
            if (ydbValue instanceof OptionalValue) {
                OptionalValue optional = ydbValue.asOptional();
                if (!optional.isPresent()) {
                    throw new SQLException("Missing required value for parameter: " + name);
                }
                ValueFactory.checkType(name, type.ydbType(), optional.getType().getItemType());
                return optional.get();
            }
            ValueFactory.checkType(name, type.ydbType(), ydbValue.getType());
            return ydbValue;
        }
        Value<?> targetValue = type.setters().toValue(value);
        if (type.isOptional()) {
            return targetValue.makeOptional();
        }
        return targetValue;
    }

    private static void checkType(String name, Type type, Type objectType) throws SQLException {
        if (!type.equals(objectType)) {
            String msg = String.format("Cannot cast parameter [%s] from [%s] to [%s]", name, objectType, type);
            throw new SQLException(msg);
        }
    }
}

