/*
 * Decompiled with CFR 0.152.
 */
package tech.ydb.jdbc.query.params;

import java.sql.SQLDataException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import tech.ydb.jdbc.common.TypeDescription;
import tech.ydb.jdbc.query.ParamDescription;
import tech.ydb.jdbc.query.YdbPreparedQuery;
import tech.ydb.jdbc.query.YdbQuery;
import tech.ydb.jdbc.query.params.ValueFactory;
import tech.ydb.table.query.Params;
import tech.ydb.table.values.Type;
import tech.ydb.table.values.Value;

public class PreparedQuery
implements YdbPreparedQuery {
    private final String yql;
    private final Map<String, ParamDescription> params;
    private final String[] paramNames;
    private final Map<String, Value<?>> paramValues = new HashMap();
    private final List<Params> batchList = new ArrayList<Params>();

    public PreparedQuery(YdbQuery query, Map<String, Type> types) {
        this.yql = query.getPreparedYql();
        this.params = new HashMap<String, ParamDescription>();
        this.paramNames = new String[types.size()];
        HashSet<String> indexedNames = new HashSet<String>();
        for (int idx = 0; idx < this.paramNames.length; ++idx) {
            String indexedName = "$p" + (1 + idx);
            if (!types.containsKey(indexedName)) continue;
            TypeDescription typeDesc = TypeDescription.of(types.get(indexedName));
            ParamDescription paramDesc = new ParamDescription(indexedName, typeDesc);
            this.params.put(indexedName, paramDesc);
            this.paramNames[idx] = indexedName;
            indexedNames.add(indexedName);
        }
        Iterator<String> sortedIter = new TreeSet<String>(types.keySet()).iterator();
        for (int idx = 0; idx < this.paramNames.length; ++idx) {
            if (this.paramNames[idx] != null) continue;
            String param = sortedIter.next();
            while (indexedNames.contains(param)) {
                param = sortedIter.next();
            }
            TypeDescription typeDesc = TypeDescription.of(types.get(param));
            ParamDescription paramDesc = new ParamDescription(param, typeDesc);
            this.params.put(param, paramDesc);
            this.paramNames[idx] = param;
        }
    }

    @Override
    public String getQueryText(Params prms) {
        return this.yql;
    }

    @Override
    public void setParam(int index, Object obj, int sqlType) throws SQLException {
        if (index <= 0 || index > this.paramNames.length) {
            throw new SQLException("Parameter is out of range: " + index);
        }
        String varName = this.paramNames[index - 1];
        ParamDescription desc = this.params.get(varName);
        this.paramValues.put(varName, ValueFactory.readValue(desc.name(), obj, desc.type()));
    }

    @Override
    public void setParam(String name, Object obj, int sqlType) throws SQLException {
        String varName = "$" + name;
        if (!this.params.containsKey(varName)) {
            throw new SQLException("Parameter not found: " + name);
        }
        ParamDescription desc = this.params.get(varName);
        this.paramValues.put(varName, ValueFactory.readValue(desc.name(), obj, desc.type()));
    }

    @Override
    public void clearParameters() {
        this.paramValues.clear();
    }

    @Override
    public void addBatch() throws SQLException {
        this.batchList.add(this.getCurrentParams());
        this.clearParameters();
    }

    @Override
    public void clearBatch() {
        this.batchList.clear();
    }

    @Override
    public int parametersCount() {
        return this.params.size();
    }

    @Override
    public int batchSize() {
        return this.batchList.size();
    }

    private Params validateParams(Map<String, Value<?>> values) throws SQLException {
        for (String key : this.params.keySet()) {
            if (values.containsKey(key)) continue;
            throw new SQLDataException("Missing value for parameter: " + key);
        }
        return Params.copyOf(values);
    }

    @Override
    public List<Params> getBatchParams() {
        return this.batchList;
    }

    @Override
    public Params getCurrentParams() throws SQLException {
        return this.validateParams(this.paramValues);
    }

    @Override
    public String getNameByIndex(int index) throws SQLException {
        if (index <= 0 || index > this.paramNames.length) {
            throw new SQLException("Parameter is out of range: " + index);
        }
        return this.paramNames[index - 1].substring("$".length());
    }

    @Override
    public TypeDescription getDescription(int index) throws SQLException {
        if (index <= 0 || index > this.paramNames.length) {
            throw new SQLException("Parameter is out of range: " + index);
        }
        String name = this.paramNames[index - 1];
        return this.params.get(name).type();
    }
}

