/*
 * Decompiled with CFR 0.152.
 */
package tech.ydb.jdbc.query;

import java.util.ArrayList;
import java.util.List;

public class YqlBatcher {
    private State state = State.INIT;
    private Cmd cmd = null;
    private String tableName = null;
    private final List<String> columns = new ArrayList<String>();
    private final List<String> values = new ArrayList<String>();
    private final List<String> keyColumns = new ArrayList<String>();
    private final List<String> keyValues = new ArrayList<String>();

    public void setForcedUpsert() {
        this.cmd = Cmd.UPSERT;
    }

    public Cmd getCommand() {
        return this.cmd;
    }

    public String getTableName() {
        return this.tableName;
    }

    public List<String> getColumns() {
        return this.columns;
    }

    public List<String> getValues() {
        return this.values;
    }

    public List<String> getKeyColumns() {
        return this.keyColumns;
    }

    public List<String> getKeyValues() {
        return this.keyValues;
    }

    public boolean isValidBatch() {
        if (this.cmd == null || this.tableName == null || this.tableName.isEmpty()) {
            return false;
        }
        if (this.cmd == Cmd.DELETE ^ this.columns.isEmpty()) {
            return false;
        }
        switch (this.cmd) {
            case INSERT: 
            case UPSERT: 
            case REPLACE: {
                return (this.state == State.VALUES_CLOSE_PAREN || this.state == State.SEMICOLON) && this.keyColumns.isEmpty() && this.keyValues.isEmpty() && this.columns.size() == this.values.size();
            }
            case DELETE: 
            case UPDATE: {
                return (this.state == State.WHERE_VALUE || this.state == State.SEMICOLON) && !this.keyColumns.isEmpty() && this.columns.size() == this.values.size() && this.keyColumns.size() == this.keyValues.size();
            }
        }
        return false;
    }

    public void readInsert() {
        if (this.state == State.INIT) {
            this.state = State.CMD;
            this.cmd = Cmd.INSERT;
            return;
        }
        this.state = State.ERROR;
    }

    public void readUpsert() {
        if (this.state == State.INIT) {
            this.state = State.CMD;
            this.cmd = Cmd.UPSERT;
            return;
        }
        this.state = State.ERROR;
    }

    public void readReplace() {
        if (this.state == State.INIT) {
            this.state = State.CMD;
            this.cmd = Cmd.REPLACE;
            return;
        }
        this.state = State.ERROR;
    }

    public void readUpdate() {
        if (this.state == State.INIT) {
            this.state = State.CMD;
            this.cmd = Cmd.UPDATE;
            return;
        }
        this.state = State.ERROR;
    }

    public void readDelete() {
        if (this.state == State.INIT) {
            this.state = State.CMD;
            this.cmd = Cmd.DELETE;
            return;
        }
        this.state = State.ERROR;
    }

    public void readOpenParen() {
        if (this.state == State.TABLE_NAME) {
            this.state = State.COLUMNS_OPEN_PAREN;
            return;
        }
        if (this.state == State.VALUES) {
            this.state = State.VALUES_OPEN_PAREN;
            return;
        }
        this.state = State.ERROR;
    }

    public void readCloseParen() {
        if (this.state == State.COLUMNS_NAME) {
            this.state = State.COLUMNS_CLOSE_PAREN;
            return;
        }
        if (this.state == State.VALUES_VALUE) {
            this.state = State.VALUES_CLOSE_PAREN;
            return;
        }
        this.state = State.ERROR;
    }

    public void readComma() {
        if (this.state == State.COLUMNS_VALUE && this.cmd == Cmd.UPDATE) {
            this.state = State.COLUMNS_COMMA;
            return;
        }
        if (this.state == State.COLUMNS_NAME && (this.cmd == Cmd.INSERT || this.cmd == Cmd.UPSERT || this.cmd == Cmd.REPLACE)) {
            this.state = State.COLUMNS_COMMA;
            return;
        }
        if (this.state == State.VALUES_VALUE) {
            this.state = State.VALUES_COMMA;
            return;
        }
        this.state = State.ERROR;
    }

    public void readEqual() {
        if (this.state == State.COLUMNS_NAME && this.cmd == Cmd.UPDATE) {
            this.state = State.COLUMNS_EQUAL;
            return;
        }
        if (this.state == State.WHERE_COLUMN && (this.cmd == Cmd.UPDATE || this.cmd == Cmd.DELETE)) {
            this.state = State.WHERE_EQUAL;
            return;
        }
        this.state = State.ERROR;
    }

    public void readSemiColon() {
        if (this.state == State.INIT || this.state == State.SEMICOLON) {
            return;
        }
        if (this.state == State.VALUES_CLOSE_PAREN || this.state == State.WHERE_VALUE) {
            this.state = State.SEMICOLON;
            return;
        }
        this.state = State.ERROR;
    }

    public void readParameter() {
        if (this.state == State.VALUES_OPEN_PAREN || this.state == State.VALUES_COMMA) {
            this.values.add("?");
            this.state = State.VALUES_VALUE;
            return;
        }
        if (this.cmd == Cmd.UPDATE && this.state == State.COLUMNS_EQUAL) {
            this.values.add("?");
            this.state = State.COLUMNS_VALUE;
            return;
        }
        if (this.state == State.WHERE_EQUAL) {
            this.keyValues.add("?");
            this.state = State.WHERE_VALUE;
            return;
        }
        this.state = State.ERROR;
    }

    public void readSingleQuoteLiteral(char[] query, int start, int length) {
        this.state = State.ERROR;
    }

    public void readDoubleQuoteLiteral(char[] query, int start, int length) {
        this.state = State.ERROR;
    }

    public void readIdentifier(char[] query, int start, int length) {
        if (this.state == State.CMD) {
            if (this.cmd == Cmd.UPDATE) {
                this.tableName = this.unquote(query, start, length);
                this.state = State.TABLE_NAME;
                return;
            }
            if (this.cmd == Cmd.DELETE && length == 4 && (query[start] | 0x20) == 102 && (query[start + 1] | 0x20) == 114 && (query[start + 2] | 0x20) == 111 && (query[start + 3] | 0x20) == 109) {
                this.state = State.FROM;
                return;
            }
            if ((this.cmd == Cmd.INSERT || this.cmd == Cmd.REPLACE || this.cmd == Cmd.UPSERT) && length == 4 && (query[start] | 0x20) == 105 && (query[start + 1] | 0x20) == 110 && (query[start + 2] | 0x20) == 116 && (query[start + 3] | 0x20) == 111) {
                this.state = State.INTO;
                return;
            }
        }
        if (this.state == State.TABLE_NAME && this.cmd == Cmd.UPDATE && length == 3 && (query[start] | 0x20) == 115 && (query[start + 1] | 0x20) == 101 && (query[start + 2] | 0x20) == 116) {
            this.state = State.SET;
            return;
        }
        if (this.state == State.COLUMNS_CLOSE_PAREN && length == 6 && (query[start] | 0x20) == 118 && (query[start + 1] | 0x20) == 97 && (query[start + 2] | 0x20) == 108 && (query[start + 3] | 0x20) == 117 && (query[start + 4] | 0x20) == 101 && (query[start + 5] | 0x20) == 115) {
            this.state = State.VALUES;
            return;
        }
        if ((this.state == State.COLUMNS_VALUE || this.state == State.TABLE_NAME && this.cmd == Cmd.DELETE) && length == 5 && (query[start] | 0x20) == 119 && (query[start + 1] | 0x20) == 104 && (query[start + 2] | 0x20) == 101 && (query[start + 3] | 0x20) == 114 && (query[start + 4] | 0x20) == 101) {
            this.state = State.WHERE;
            return;
        }
        if (this.state == State.WHERE_VALUE && length == 3 && (query[start] | 0x20) == 97 && (query[start + 1] | 0x20) == 110 && (query[start + 2] | 0x20) == 100) {
            this.state = State.WHERE_AND;
            return;
        }
        if (this.state == State.INTO && (this.cmd == Cmd.INSERT || this.cmd == Cmd.UPSERT || this.cmd == Cmd.REPLACE)) {
            this.tableName = this.unquote(query, start, length);
            this.state = State.TABLE_NAME;
            return;
        }
        if (this.state == State.FROM && this.cmd == Cmd.DELETE) {
            this.tableName = this.unquote(query, start, length);
            this.state = State.TABLE_NAME;
            return;
        }
        if (this.state == State.COLUMNS_OPEN_PAREN || this.state == State.COLUMNS_COMMA || this.state == State.SET) {
            this.columns.add(this.unquote(query, start, length));
            this.state = State.COLUMNS_NAME;
            return;
        }
        if (this.state == State.WHERE || this.state == State.WHERE_AND) {
            this.keyColumns.add(this.unquote(query, start, length));
            this.state = State.WHERE_COLUMN;
            return;
        }
        this.state = State.ERROR;
    }

    private String unquote(char[] chars, int start, int length) {
        if (chars[start] == '`' && chars[start + length - 1] == '`') {
            return String.valueOf(chars, start + 1, length - 2);
        }
        return String.valueOf(chars, start, length);
    }

    private static enum State {
        INIT,
        CMD,
        INTO,
        FROM,
        SET,
        TABLE_NAME,
        COLUMNS_OPEN_PAREN,
        COLUMNS_COMMA,
        COLUMNS_EQUAL,
        COLUMNS_NAME,
        COLUMNS_VALUE,
        COLUMNS_CLOSE_PAREN,
        VALUES,
        VALUES_OPEN_PAREN,
        VALUES_COMMA,
        VALUES_VALUE,
        VALUES_CLOSE_PAREN,
        WHERE,
        WHERE_COLUMN,
        WHERE_EQUAL,
        WHERE_VALUE,
        WHERE_AND,
        SEMICOLON,
        ERROR;

    }

    public static enum Cmd {
        UPSERT,
        INSERT,
        REPLACE,
        UPDATE,
        DELETE;

    }
}

