/*
 * Decompiled with CFR 0.152.
 */
package tech.ydb.jdbc.impl;

import java.sql.SQLException;
import java.util.Objects;
import tech.ydb.jdbc.YdbStatement;
import tech.ydb.jdbc.common.ColumnInfo;
import tech.ydb.jdbc.impl.BaseYdbResultSet;
import tech.ydb.table.result.ResultSetReader;
import tech.ydb.table.result.ValueReader;

public class YdbStaticResultSet
extends BaseYdbResultSet {
    private final ResultSetReader rsReader;
    private final int rowCount;
    private int fetchDirection = 1002;
    private int rowIndex = 0;
    private boolean isClosed = false;

    public YdbStaticResultSet(YdbStatement statement, ResultSetReader result) {
        super(statement, ColumnInfo.fromResultSetReader(Objects.requireNonNull(result)));
        this.rsReader = result;
        this.rowCount = result.getRowCount();
    }

    @Override
    protected ValueReader getValue(int columnIndex) throws SQLException {
        try {
            return this.rsReader.getColumn(columnIndex);
        }
        catch (IllegalStateException ex) {
            throw new SQLException("Current row index is out of bounds: " + this.rowIndex);
        }
    }

    @Override
    public boolean next() {
        this.setRowIndex(this.rowIndex + 1);
        return this.isRowIndexValid();
    }

    @Override
    public void close() {
        this.isClosed = true;
    }

    @Override
    public boolean isBeforeFirst() {
        return this.rowCount != 0 && this.rowIndex <= 0;
    }

    @Override
    public boolean isAfterLast() {
        return this.rowCount != 0 && this.rowIndex > this.rowCount;
    }

    @Override
    public boolean isFirst() {
        return this.rowCount != 0 && this.rowIndex == 1;
    }

    @Override
    public boolean isLast() {
        return this.rowCount != 0 && this.rowIndex == this.rowCount;
    }

    @Override
    public void beforeFirst() throws SQLException {
        this.checkScroll();
        this.setRowIndex(0);
    }

    @Override
    public void afterLast() throws SQLException {
        this.checkScroll();
        this.setRowIndex(this.rowCount + 1);
    }

    @Override
    public boolean first() throws SQLException {
        this.checkScroll();
        this.setRowIndex(1);
        return this.isRowIndexValid();
    }

    @Override
    public boolean last() throws SQLException {
        this.checkScroll();
        this.setRowIndex(this.rowCount);
        return this.isRowIndexValid();
    }

    @Override
    public int getRow() {
        return this.rowIndex;
    }

    @Override
    public boolean absolute(int row) throws SQLException {
        this.checkScroll();
        if (row >= 0) {
            this.setRowIndex(row);
        } else {
            this.setRowIndex(this.rowCount + 1 + row);
        }
        return this.isRowIndexValid();
    }

    @Override
    public boolean relative(int rows) throws SQLException {
        this.checkScroll();
        if (rows != 0) {
            this.setRowIndex(this.rowIndex + rows);
        }
        return this.isRowIndexValid();
    }

    @Override
    public boolean previous() throws SQLException {
        this.checkScroll();
        this.setRowIndex(this.rowIndex - 1);
        return this.isRowIndexValid();
    }

    @Override
    public void setFetchDirection(int direction) throws SQLException {
        this.fetchDirection = direction;
    }

    @Override
    public int getFetchDirection() {
        return this.fetchDirection;
    }

    @Override
    public void setFetchSize(int rows) {
    }

    @Override
    public int getFetchSize() throws SQLException {
        return this.statement.getFetchSize();
    }

    @Override
    public int getType() throws SQLException {
        return this.statement.getResultSetType();
    }

    @Override
    public boolean isClosed() {
        return this.isClosed;
    }

    private void checkScroll() throws SQLException {
        if (this.getType() == 1003) {
            throw new SQLException("ResultSet in TYPE_FORWARD_ONLY mode");
        }
    }

    private void setRowIndex(int rowIndex) {
        if (this.rowCount > 0) {
            int actualIndex;
            this.rowIndex = actualIndex = Math.max(Math.min(rowIndex, this.rowCount + 1), 0);
            this.rsReader.setRowIndex(actualIndex - 1);
        }
    }

    private boolean isRowIndexValid() {
        return this.rowIndex > 0 && this.rowIndex <= this.rowCount;
    }
}

