/*
 * Decompiled with CFR 0.152.
 */
package tech.ydb.jdbc.exception;

import java.sql.SQLException;
import tech.ydb.core.StatusCode;
import tech.ydb.core.UnexpectedResultException;
import tech.ydb.jdbc.exception.YdbConditionallyRetryableException;
import tech.ydb.jdbc.exception.YdbRetryableException;
import tech.ydb.jdbc.exception.YdbSQLException;
import tech.ydb.jdbc.exception.YdbTimeoutException;
import tech.ydb.jdbc.exception.YdbUnavailbaleException;

public class ExceptionFactory {
    private ExceptionFactory() {
    }

    static String getSQLState(StatusCode status) {
        return null;
    }

    static int getVendorCode(StatusCode code) {
        return code.getCode();
    }

    public static SQLException createException(String message, UnexpectedResultException cause) {
        StatusCode code = cause.getStatus().getCode();
        String sqlState = ExceptionFactory.getSQLState(code);
        int vendorCode = ExceptionFactory.getVendorCode(code);
        if (code.isRetryable(false)) {
            return new YdbRetryableException(message, sqlState, vendorCode, cause);
        }
        if (code == StatusCode.TRANSPORT_UNAVAILABLE || code == StatusCode.UNAVAILABLE) {
            return new YdbUnavailbaleException(message, sqlState, vendorCode, cause);
        }
        if (code == StatusCode.TIMEOUT || code == StatusCode.CLIENT_DEADLINE_EXPIRED || code == StatusCode.CLIENT_DEADLINE_EXCEEDED) {
            return new YdbTimeoutException(message, sqlState, vendorCode, cause);
        }
        if (code.isRetryable(true)) {
            return new YdbConditionallyRetryableException(message, sqlState, vendorCode, cause);
        }
        return new YdbSQLException(message, sqlState, vendorCode, cause);
    }
}

