/*
 * Decompiled with CFR 0.152.
 */
package tech.ydb.jdbc.context;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import tech.ydb.jdbc.YdbResultSet;
import tech.ydb.jdbc.YdbStatement;
import tech.ydb.jdbc.common.FixedResultSetFactory;
import tech.ydb.jdbc.impl.YdbQueryResult;
import tech.ydb.jdbc.impl.YdbStaticResultSet;
import tech.ydb.jdbc.query.QueryStatement;
import tech.ydb.jdbc.query.YdbQuery;
import tech.ydb.table.result.ResultSetReader;

public class StaticQueryResult
implements YdbQueryResult {
    private static final FixedResultSetFactory EXPLAIN_RS_FACTORY = FixedResultSetFactory.newBuilder().addTextColumn("AST").addTextColumn("PLAN").build();
    private static final ExpressionResult NO_UPDATED = new ExpressionResult(0);
    private static final ExpressionResult HAS_UPDATED = new ExpressionResult(1);
    private final List<ExpressionResult> results;
    private int resultIndex;

    public StaticQueryResult(YdbQuery query, List<YdbResultSet> list) {
        this.results = new ArrayList<ExpressionResult>();
        this.resultIndex = 0;
        int idx = 0;
        for (QueryStatement exp : query.getStatements()) {
            if (exp.isDDL()) {
                this.results.add(NO_UPDATED);
                continue;
            }
            if (exp.hasUpdateCount()) {
                this.results.add(HAS_UPDATED);
                continue;
            }
            if (!exp.hasResults() || idx >= list.size()) continue;
            this.results.add(new ExpressionResult(list.get(idx)));
            ++idx;
        }
        while (idx < list.size()) {
            this.results.add(new ExpressionResult(list.get(idx)));
            ++idx;
        }
    }

    public StaticQueryResult(YdbStatement statement, String ast, String plan) {
        ResultSetReader result = EXPLAIN_RS_FACTORY.createResultSet().newRow().withTextValue("AST", ast).withTextValue("PLAN", plan).build().build();
        YdbStaticResultSet rs = new YdbStaticResultSet(statement, result);
        this.results = Collections.singletonList(new ExpressionResult(rs));
        this.resultIndex = 0;
    }

    @Override
    public void close() {
    }

    @Override
    public boolean hasResultSets() {
        if (this.results == null || this.resultIndex >= this.results.size()) {
            return false;
        }
        return this.results.get(this.resultIndex).resultSet != null;
    }

    @Override
    public int getUpdateCount() {
        if (this.results == null || this.resultIndex >= this.results.size()) {
            return -1;
        }
        return this.results.get(this.resultIndex).updateCount;
    }

    @Override
    public YdbResultSet getCurrentResultSet() {
        if (this.results == null || this.resultIndex >= this.results.size()) {
            return null;
        }
        return this.results.get(this.resultIndex).resultSet;
    }

    @Override
    public boolean getMoreResults(int current) throws SQLException {
        if (this.results == null || this.resultIndex >= this.results.size()) {
            return false;
        }
        switch (current) {
            case 2: {
                break;
            }
            case 1: {
                this.results.get(this.resultIndex).resultSet.close();
                break;
            }
            case 3: {
                for (int idx = 0; idx <= this.resultIndex; ++idx) {
                    this.results.get(idx).resultSet.close();
                }
                break;
            }
            default: {
                throw new SQLException("ResultSet mode is not supported: " + current);
            }
        }
        ++this.resultIndex;
        return this.hasResultSets();
    }

    private static class ExpressionResult {
        private final int updateCount;
        private final YdbResultSet resultSet;

        ExpressionResult(int updateCount) {
            this.updateCount = updateCount;
            this.resultSet = null;
        }

        ExpressionResult(YdbResultSet resultSet) {
            this.updateCount = -1;
            this.resultSet = resultSet;
        }
    }
}

