/*
 * Decompiled with CFR 0.152.
 */
package tech.ydb.jdbc.context;

import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import tech.ydb.common.transaction.TxMode;
import tech.ydb.core.Issue;
import tech.ydb.core.Result;
import tech.ydb.core.UnexpectedResultException;
import tech.ydb.jdbc.YdbResultSet;
import tech.ydb.jdbc.YdbStatement;
import tech.ydb.jdbc.YdbTracer;
import tech.ydb.jdbc.context.BaseYdbExecutor;
import tech.ydb.jdbc.context.StaticQueryResult;
import tech.ydb.jdbc.context.StreamQueryResult;
import tech.ydb.jdbc.context.YdbContext;
import tech.ydb.jdbc.context.YdbValidator;
import tech.ydb.jdbc.exception.ExceptionFactory;
import tech.ydb.jdbc.impl.YdbQueryResult;
import tech.ydb.jdbc.impl.YdbStaticResultSet;
import tech.ydb.jdbc.query.QueryType;
import tech.ydb.jdbc.query.YdbQuery;
import tech.ydb.query.QueryClient;
import tech.ydb.query.QuerySession;
import tech.ydb.query.QueryStream;
import tech.ydb.query.QueryTransaction;
import tech.ydb.query.result.QueryInfo;
import tech.ydb.query.result.QueryResultPart;
import tech.ydb.query.settings.CommitTransactionSettings;
import tech.ydb.query.settings.ExecuteQuerySettings;
import tech.ydb.query.settings.QueryExecMode;
import tech.ydb.query.settings.RollbackTransactionSettings;
import tech.ydb.query.tools.QueryReader;
import tech.ydb.table.query.Params;
import tech.ydb.table.result.ResultSetReader;

public class QueryServiceExecutor
extends BaseYdbExecutor {
    private final Duration sessionTimeout;
    private final QueryClient queryClient;
    private final boolean useStreamResultSet;
    private int transactionLevel;
    private boolean isReadOnly;
    private boolean isAutoCommit;
    private TxMode txMode;
    private final AtomicReference<QueryTransaction> tx = new AtomicReference();
    private volatile boolean isClosed;

    public QueryServiceExecutor(YdbContext ctx, int transactionLevel, boolean autoCommit) throws SQLException {
        super(ctx);
        this.sessionTimeout = ctx.getOperationProperties().getSessionTimeout();
        this.queryClient = ctx.getQueryClient();
        this.useStreamResultSet = ctx.getOperationProperties().getUseStreamResultSets();
        this.transactionLevel = transactionLevel;
        this.isReadOnly = transactionLevel != 8;
        this.isAutoCommit = autoCommit;
        this.txMode = QueryServiceExecutor.txMode(transactionLevel, this.isReadOnly);
        this.isClosed = false;
    }

    protected QuerySession createNewQuerySession(YdbValidator validator) throws SQLException {
        try {
            Result<QuerySession> result = this.queryClient.createSession(this.sessionTimeout).join();
            validator.addStatusIssues(result.getStatus());
            QuerySession session = result.getValue();
            return session;
        }
        catch (UnexpectedResultException ex) {
            throw ExceptionFactory.createException("Cannot create session with " + ex.getStatus(), ex);
        }
    }

    @Override
    public void close() throws SQLException {
        this.closeCurrentResult();
        this.isClosed = true;
        QueryTransaction old = this.tx.getAndSet(null);
        if (old != null) {
            old.getSession().close();
        }
    }

    @Override
    public void setTransactionLevel(int level) throws SQLException {
        this.ensureOpened();
        if (level == this.transactionLevel) {
            return;
        }
        QueryTransaction localTx = this.tx.get();
        if (localTx != null && localTx.isActive()) {
            throw new SQLFeatureNotSupportedException("Cannot change transaction isolation inside a transaction");
        }
        this.isReadOnly = this.isReadOnly || level != 8;
        this.transactionLevel = level;
        this.txMode = QueryServiceExecutor.txMode(this.transactionLevel, this.isReadOnly);
    }

    @Override
    public void setReadOnly(boolean readOnly) throws SQLException {
        this.ensureOpened();
        if (readOnly == this.isReadOnly) {
            return;
        }
        QueryTransaction localTx = this.tx.get();
        if (localTx != null && localTx.isActive()) {
            throw new SQLFeatureNotSupportedException("Cannot change read-only attribute inside a transaction");
        }
        this.isReadOnly = readOnly;
        this.txMode = QueryServiceExecutor.txMode(this.transactionLevel, this.isReadOnly);
    }

    @Override
    public void setAutoCommit(boolean autoCommit) throws SQLException {
        this.ensureOpened();
        if (autoCommit == this.isAutoCommit) {
            return;
        }
        QueryTransaction localTx = this.tx.get();
        if (localTx != null && localTx.isActive()) {
            throw new SQLFeatureNotSupportedException("Cannot change transaction isolation inside a transaction");
        }
        this.isAutoCommit = autoCommit;
    }

    @Override
    public boolean isClosed() throws SQLException {
        this.closeCurrentResult();
        return this.isClosed;
    }

    @Override
    public String txID() throws SQLException {
        this.closeCurrentResult();
        QueryTransaction localTx = this.tx.get();
        return localTx != null ? localTx.getId() : null;
    }

    @Override
    public boolean isInsideTransaction() throws SQLException {
        this.ensureOpened();
        QueryTransaction localTx = this.tx.get();
        return localTx != null && localTx.isActive();
    }

    @Override
    public boolean isAutoCommit() throws SQLException {
        this.ensureOpened();
        return this.isAutoCommit;
    }

    @Override
    public boolean isReadOnly() throws SQLException {
        this.ensureOpened();
        return this.isReadOnly;
    }

    @Override
    public int transactionLevel() throws SQLException {
        this.ensureOpened();
        return this.transactionLevel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void commit(YdbContext ctx, YdbValidator validator) throws SQLException {
        this.ensureOpened();
        QueryTransaction localTx = this.tx.get();
        if (localTx == null || !localTx.isActive()) {
            return;
        }
        YdbTracer tracer = this.trace("--> commit");
        CommitTransactionSettings settings = ctx.withRequestTimeout(CommitTransactionSettings.newBuilder()).build();
        try {
            validator.clearWarnings();
            validator.call("Commit TxId: " + localTx.getId(), tracer, () -> localTx.commit(settings));
        }
        finally {
            if (this.tx.compareAndSet(localTx, null)) {
                localTx.getSession().close();
            }
            if (tracer != null) {
                tracer.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void rollback(YdbContext ctx, YdbValidator validator) throws SQLException {
        this.ensureOpened();
        QueryTransaction localTx = this.tx.get();
        if (localTx == null || !localTx.isActive()) {
            return;
        }
        YdbTracer tracer = this.trace("--> rollback");
        RollbackTransactionSettings settings = ctx.withRequestTimeout(RollbackTransactionSettings.newBuilder()).build();
        try {
            validator.clearWarnings();
            validator.execute("Rollback TxId: " + localTx.getId(), tracer, () -> localTx.rollback(settings));
        }
        finally {
            if (this.tx.compareAndSet(localTx, null)) {
                localTx.getSession().close();
            }
            if (tracer != null) {
                tracer.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public YdbQueryResult executeDataQuery(YdbStatement statement, YdbQuery query, String yql, Params params, long timeout, boolean keepInCache) throws SQLException {
        this.ensureOpened();
        final YdbValidator validator = statement.getValidator();
        ExecuteQuerySettings.Builder builder = ExecuteQuerySettings.newBuilder();
        if (timeout > 0L) {
            builder = (ExecuteQuerySettings.Builder)builder.withRequestTimeout(timeout, TimeUnit.SECONDS);
        }
        ExecuteQuerySettings settings = builder.build();
        QueryTransaction nextTx = this.tx.get();
        while (nextTx == null) {
            nextTx = this.createNewQuerySession(validator).createNewTransaction(this.txMode);
            if (this.tx.compareAndSet(null, nextTx)) continue;
            nextTx.getSession().close();
            nextTx = this.tx.get();
        }
        QueryTransaction localTx = nextTx;
        if (this.useStreamResultSet) {
            YdbTracer tracer = this.trace("--> stream query >>\n" + yql);
            String msg = "STREAM_QUERY >>\n" + yql;
            StreamQueryResult lazy = (StreamQueryResult)validator.call(msg, null, () -> {
                final CompletableFuture future = new CompletableFuture();
                QueryStream stream = localTx.createQuery(yql, this.isAutoCommit, params, settings);
                final StreamQueryResult result = new StreamQueryResult(msg, statement, query, stream::cancel);
                stream.execute(new QueryStream.PartsHandler(){

                    @Override
                    public void onIssues(Issue[] issues) {
                        validator.addStatusIssues(Arrays.asList(issues));
                    }

                    @Override
                    public void onNextPart(QueryResultPart part) {
                        result.onStreamResultSet((int)part.getResultSetIndex(), part.getResultSetReader());
                        future.complete(Result.success(result));
                    }
                }).whenComplete((res, th) -> {
                    if (!localTx.isActive() && this.tx.compareAndSet(localTx, null)) {
                        localTx.getSession().close();
                    }
                    if (th != null) {
                        future.completeExceptionally((Throwable)th);
                        result.onStreamFinished((Throwable)th);
                        if (tracer != null) {
                            tracer.trace("<-- " + th.getMessage());
                            if (localTx.isActive()) {
                                tracer.setId(localTx.getId());
                            } else {
                                tracer.close();
                            }
                        }
                    }
                    if (res != null) {
                        validator.addStatusIssues(res.getStatus());
                        future.complete(res.isSuccess() ? Result.success(result) : Result.fail(res.getStatus()));
                        result.onStreamFinished(res.getStatus());
                        if (tracer != null) {
                            tracer.trace("<-- " + res.getStatus().toString());
                            if (localTx.isActive()) {
                                tracer.setId(localTx.getId());
                            } else {
                                tracer.close();
                            }
                        }
                    }
                });
                return future;
            });
            return this.updateCurrentResult(lazy);
        }
        YdbTracer tracer = this.trace("--> data query >>\n" + yql);
        try {
            QueryReader result = (QueryReader)validator.call((Object)((Object)QueryType.DATA_QUERY) + " >>\n" + yql, tracer, () -> QueryReader.readFrom(localTx.createQuery(yql, this.isAutoCommit, params, settings)));
            validator.addStatusIssues(result.getIssueList());
            ArrayList<YdbResultSet> readers = new ArrayList<YdbResultSet>();
            for (ResultSetReader rst : result) {
                readers.add(new YdbStaticResultSet(statement, rst));
            }
            YdbQueryResult ydbQueryResult = this.updateCurrentResult(new StaticQueryResult(query, readers));
            return ydbQueryResult;
        }
        finally {
            if (!localTx.isActive() && this.tx.compareAndSet(localTx, null)) {
                localTx.getSession().close();
            }
            if (tracer != null) {
                if (localTx.isActive()) {
                    tracer.setId(localTx.getId());
                } else {
                    tracer.close();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public YdbQueryResult executeSchemeQuery(YdbStatement statement, YdbQuery query) throws SQLException {
        this.ensureOpened();
        String yql = query.getPreparedYql();
        YdbContext ctx = statement.getConnection().getCtx();
        YdbValidator validator = statement.getValidator();
        YdbTracer tracer = this.trace("--> scheme query >>\n" + yql);
        ExecuteQuerySettings settings = ctx.withRequestTimeout(ExecuteQuerySettings.newBuilder()).build();
        try (QuerySession session = this.createNewQuerySession(validator);){
            validator.call((Object)((Object)QueryType.SCHEME_QUERY) + " >>\n" + yql, tracer, () -> session.createQuery(yql, TxMode.NONE, Params.empty(), settings).execute(new IssueHandler(validator)));
        }
        finally {
            if (tracer != null && this.tx.get() == null) {
                tracer.close();
            }
        }
        return this.updateCurrentResult(new StaticQueryResult(query, Collections.emptyList()));
    }

    /*
     * Loose catch block
     */
    @Override
    public YdbQueryResult executeExplainQuery(YdbStatement statement, YdbQuery query) throws SQLException {
        this.ensureOpened();
        String yql = query.getPreparedYql();
        YdbContext ctx = statement.getConnection().getCtx();
        YdbValidator validator = statement.getValidator();
        ExecuteQuerySettings settings = ctx.withRequestTimeout(ExecuteQuerySettings.newBuilder()).withExecMode(QueryExecMode.EXPLAIN).build();
        YdbTracer tracer = this.trace("--> explain query >>\n" + yql);
        try {
            try (QuerySession session = this.createNewQuerySession(validator);){
                QueryInfo res = (QueryInfo)validator.call((Object)((Object)QueryType.EXPLAIN_QUERY) + " >>\n" + yql, tracer, () -> session.createQuery(yql, TxMode.NONE, Params.empty(), settings).execute(new IssueHandler(validator)));
                if (!res.hasStats()) {
                    throw new SQLException("No explain data");
                }
                YdbQueryResult ydbQueryResult = this.updateCurrentResult(new StaticQueryResult(statement, res.getStats().getQueryAst(), res.getStats().getQueryPlan()));
                return ydbQueryResult;
            }
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            if (tracer != null && this.tx.get() == null) {
                tracer.close();
            }
        }
    }

    @Override
    public boolean isValid(YdbValidator validator, int timeout) throws SQLException {
        this.ensureOpened();
        return true;
    }

    private static TxMode txMode(int level, boolean isReadOnly) throws SQLException {
        if (!isReadOnly) {
            if (level != 8) {
                throw new SQLException("Unsupported transaction level: " + level);
            }
            return TxMode.SERIALIZABLE_RW;
        }
        switch (level) {
            case 8: {
                return TxMode.SNAPSHOT_RO;
            }
            case 16: {
                return TxMode.ONLINE_RO;
            }
            case 17: {
                return TxMode.ONLINE_INCONSISTENT_RO;
            }
            case 32: {
                return TxMode.STALE_RO;
            }
        }
        throw new SQLException("Unsupported transaction level: " + level);
    }

    private class IssueHandler
    implements QueryStream.PartsHandler {
        private final YdbValidator validator;

        IssueHandler(YdbValidator validator) {
            this.validator = validator;
        }

        @Override
        public void onIssues(Issue[] issues) {
            this.validator.addStatusIssues(Arrays.asList(issues));
        }

        @Override
        public void onNextPart(QueryResultPart part) {
        }
    }
}

