/*
 * Decompiled with CFR 0.152.
 */
package tech.ydb.jdbc.common;

import tech.ydb.jdbc.common.MappingGetters;
import tech.ydb.jdbc.common.TypeDescription;
import tech.ydb.table.result.ResultSetReader;
import tech.ydb.table.values.PrimitiveType;
import tech.ydb.table.values.Type;

public class ColumnInfo {
    private final String name;
    private final Type ydbType;
    private final MappingGetters.SqlType sqlType;
    private final MappingGetters.Getters getters;
    private final boolean isOptional;
    private final boolean isTimestamp;
    private final boolean isNumber;
    private final boolean isNull;

    public ColumnInfo(String name, Type type) {
        this.name = name;
        TypeDescription desc = TypeDescription.of(type);
        this.sqlType = desc.sqlType();
        this.getters = desc.getters();
        this.isOptional = desc.isOptional();
        this.ydbType = desc.ydbType();
        this.isTimestamp = this.ydbType == PrimitiveType.Timestamp;
        this.isNumber = this.ydbType == PrimitiveType.Int8 || this.ydbType == PrimitiveType.Uint8 || this.ydbType == PrimitiveType.Int16 || this.ydbType == PrimitiveType.Uint16 || this.ydbType == PrimitiveType.Int32 || this.ydbType == PrimitiveType.Uint32 || this.ydbType == PrimitiveType.Int64 || this.ydbType == PrimitiveType.Uint64;
        this.isNull = this.ydbType.getKind() == Type.Kind.NULL || this.ydbType.getKind() == Type.Kind.VOID;
    }

    public String getName() {
        return this.name;
    }

    public Type getYdbType() {
        return this.ydbType;
    }

    public boolean isNull() {
        return this.isNull;
    }

    public boolean isTimestamp() {
        return this.isTimestamp;
    }

    public boolean isNumber() {
        return this.isNumber;
    }

    public boolean isOptional() {
        return this.isOptional;
    }

    public MappingGetters.SqlType getSqlType() {
        return this.sqlType;
    }

    public MappingGetters.Getters getGetters() {
        return this.getters;
    }

    public static ColumnInfo[] fromResultSetReader(ResultSetReader rsr) {
        ColumnInfo[] columns = new ColumnInfo[rsr.getColumnCount()];
        for (int idx = 0; idx < rsr.getColumnCount(); ++idx) {
            columns[idx] = new ColumnInfo(rsr.getColumnName(idx), rsr.getColumnType(idx));
        }
        return columns;
    }
}

