/*
 * Decompiled with CFR 0.152.
 */
package tech.ydb.core.impl.pool;

import java.io.ByteArrayInputStream;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import javax.net.ssl.SSLException;
import tech.ydb.core.grpc.GrpcTransportBuilder;
import tech.ydb.core.grpc.YdbHeaders;
import tech.ydb.core.impl.pool.ManagedChannelFactory;
import tech.ydb.core.ssl.YandexTrustManagerFactory;
import tech.ydb.shaded.grpc.ClientInterceptor;
import tech.ydb.shaded.grpc.ManagedChannel;
import tech.ydb.shaded.grpc.Metadata;
import tech.ydb.shaded.grpc.internal.DnsNameResolverProvider;
import tech.ydb.shaded.grpc.netty.shaded.io.grpc.netty.GrpcSslContexts;
import tech.ydb.shaded.grpc.netty.shaded.io.grpc.netty.NegotiationType;
import tech.ydb.shaded.grpc.netty.shaded.io.grpc.netty.NettyChannelBuilder;
import tech.ydb.shaded.grpc.netty.shaded.io.netty.buffer.ByteBufAllocator;
import tech.ydb.shaded.grpc.netty.shaded.io.netty.channel.ChannelOption;
import tech.ydb.shaded.grpc.netty.shaded.io.netty.handler.ssl.SslContext;
import tech.ydb.shaded.grpc.netty.shaded.io.netty.handler.ssl.SslContextBuilder;
import tech.ydb.shaded.grpc.stub.MetadataUtils;

public class ShadedNettyChannelFactory
implements ManagedChannelFactory {
    static final int INBOUND_MESSAGE_SIZE = 0x4000000;
    static final String DEFAULT_BALANCER_POLICY = "round_robin";
    private final String database;
    private final String version;
    private final boolean useTLS;
    private final byte[] cert;
    private final boolean retryEnabled;
    private final long connectTimeoutMs;
    private final boolean useDefaultGrpcResolver;
    private final Long grpcKeepAliveTimeMillis;

    public ShadedNettyChannelFactory(GrpcTransportBuilder builder) {
        this.database = builder.getDatabase();
        this.version = builder.getVersionString();
        this.useTLS = builder.getUseTls();
        this.cert = builder.getCert();
        this.retryEnabled = builder.isEnableRetry();
        this.connectTimeoutMs = builder.getConnectTimeoutMillis();
        this.useDefaultGrpcResolver = builder.useDefaultGrpcResolver();
        this.grpcKeepAliveTimeMillis = builder.getGrpcKeepAliveTimeMillis();
    }

    @Override
    public long getConnectTimeoutMs() {
        return this.connectTimeoutMs;
    }

    @Override
    public ManagedChannel newManagedChannel(String host, int port) {
        NettyChannelBuilder channelBuilder = NettyChannelBuilder.forAddress(host, port);
        if (this.useTLS) {
            channelBuilder.negotiationType(NegotiationType.TLS).sslContext(this.createSslContext());
        } else {
            channelBuilder.negotiationType(NegotiationType.PLAINTEXT);
        }
        channelBuilder.maxInboundMessageSize(0x4000000).withOption(ChannelOption.ALLOCATOR, ByteBufAllocator.DEFAULT).intercept(this.metadataInterceptor());
        if (!this.useDefaultGrpcResolver) {
            ((NettyChannelBuilder)channelBuilder.nameResolverFactory(new DnsNameResolverProvider())).defaultLoadBalancingPolicy(DEFAULT_BALANCER_POLICY);
        }
        if (this.grpcKeepAliveTimeMillis != null) {
            channelBuilder.keepAliveTime(this.grpcKeepAliveTimeMillis, TimeUnit.MILLISECONDS);
        }
        if (this.retryEnabled) {
            channelBuilder.enableRetry();
        } else {
            channelBuilder.disableRetry();
        }
        this.configure(channelBuilder);
        return channelBuilder.build();
    }

    protected void configure(NettyChannelBuilder channelBuilder) {
    }

    private ClientInterceptor metadataInterceptor() {
        Metadata extraHeaders = new Metadata();
        extraHeaders.put(YdbHeaders.DATABASE, this.database);
        extraHeaders.put(YdbHeaders.BUILD_INFO, this.version);
        return MetadataUtils.newAttachHeadersInterceptor(extraHeaders);
    }

    private SslContext createSslContext() {
        try {
            SslContextBuilder sslContextBuilder = GrpcSslContexts.forClient();
            if (this.cert != null) {
                sslContextBuilder.trustManager(new ByteArrayInputStream(this.cert));
            } else {
                sslContextBuilder.trustManager(new YandexTrustManagerFactory(""));
            }
            return sslContextBuilder.build();
        }
        catch (RuntimeException | SSLException e) {
            throw new RuntimeException("cannot create ssl context", e);
        }
    }

    public static ManagedChannelFactory.Builder build() {
        return new ManagedChannelFactory.Builder(){

            @Override
            public ManagedChannelFactory buildFactory(GrpcTransportBuilder builder) {
                return new ShadedNettyChannelFactory(builder);
            }

            public String toString() {
                return "ShadedNettyChannelFactory";
            }
        };
    }

    public static ManagedChannelFactory.Builder withInterceptor(final Consumer<NettyChannelBuilder> ci) {
        return builder -> new ShadedNettyChannelFactory(builder){

            @Override
            protected void configure(NettyChannelBuilder channelBuilder) {
                if (ci != null) {
                    ci.accept(channelBuilder);
                }
            }
        };
    }
}

