/*
 * Decompiled with CFR 0.152.
 */
package tech.ydb.core.impl.pool;

import io.netty.buffer.ByteBufAllocator;
import io.netty.channel.ChannelOption;
import io.netty.handler.ssl.SslContext;
import io.netty.handler.ssl.SslContextBuilder;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import javax.net.ssl.SSLException;
import javax.net.ssl.TrustManagerFactory;
import tech.ydb.core.grpc.GrpcTransportBuilder;
import tech.ydb.core.grpc.YdbHeaders;
import tech.ydb.core.impl.pool.ManagedChannelFactory;
import tech.ydb.core.ssl.YandexTrustManagerFactory;
import tech.ydb.shaded.grpc.ClientInterceptor;
import tech.ydb.shaded.grpc.ManagedChannel;
import tech.ydb.shaded.grpc.Metadata;
import tech.ydb.shaded.grpc.NameResolver;
import tech.ydb.shaded.grpc.internal.DnsNameResolverProvider;
import tech.ydb.shaded.grpc.netty.GrpcSslContexts;
import tech.ydb.shaded.grpc.netty.NegotiationType;
import tech.ydb.shaded.grpc.netty.NettyChannelBuilder;
import tech.ydb.shaded.grpc.stub.MetadataUtils;

public class NettyChannelFactory
implements ManagedChannelFactory {
    static final int INBOUND_MESSAGE_SIZE = 0x4000000;
    static final String DEFAULT_BALANCER_POLICY = "round_robin";
    private final String database;
    private final String version;
    private final boolean useTLS;
    private final byte[] cert;
    private final boolean retryEnabled;
    private final long connectTimeoutMs;
    private final boolean useDefaultGrpcResolver;
    private final Long grpcKeepAliveTimeMillis;

    private NettyChannelFactory(GrpcTransportBuilder builder) {
        this.database = builder.getDatabase();
        this.version = builder.getVersionString();
        this.useTLS = builder.getUseTls();
        this.cert = builder.getCert();
        this.retryEnabled = builder.isEnableRetry();
        this.connectTimeoutMs = builder.getConnectTimeoutMillis();
        this.useDefaultGrpcResolver = builder.useDefaultGrpcResolver();
        this.grpcKeepAliveTimeMillis = builder.getGrpcKeepAliveTimeMillis();
    }

    @Override
    public long getConnectTimeoutMs() {
        return this.connectTimeoutMs;
    }

    @Override
    public ManagedChannel newManagedChannel(String host, int port) {
        NettyChannelBuilder channelBuilder = NettyChannelBuilder.forAddress((String)host, (int)port);
        if (this.useTLS) {
            channelBuilder.negotiationType(NegotiationType.TLS).sslContext(this.createSslContext());
        } else {
            channelBuilder.negotiationType(NegotiationType.PLAINTEXT);
        }
        channelBuilder.maxInboundMessageSize(0x4000000).withOption(ChannelOption.ALLOCATOR, (Object)ByteBufAllocator.DEFAULT).intercept(new ClientInterceptor[]{this.metadataInterceptor()});
        if (!this.useDefaultGrpcResolver) {
            ((NettyChannelBuilder)channelBuilder.nameResolverFactory((NameResolver.Factory)new DnsNameResolverProvider())).defaultLoadBalancingPolicy(DEFAULT_BALANCER_POLICY);
        }
        if (this.grpcKeepAliveTimeMillis != null) {
            channelBuilder.keepAliveTime(this.grpcKeepAliveTimeMillis.longValue(), TimeUnit.MILLISECONDS);
        }
        if (this.retryEnabled) {
            channelBuilder.enableRetry();
        } else {
            channelBuilder.disableRetry();
        }
        this.configure(channelBuilder);
        return channelBuilder.build();
    }

    protected void configure(NettyChannelBuilder channelBuilder) {
    }

    private ClientInterceptor metadataInterceptor() {
        Metadata extraHeaders = new Metadata();
        extraHeaders.put(YdbHeaders.DATABASE, this.database);
        extraHeaders.put(YdbHeaders.BUILD_INFO, this.version);
        return MetadataUtils.newAttachHeadersInterceptor(extraHeaders);
    }

    private SslContext createSslContext() {
        try {
            SslContextBuilder sslContextBuilder = GrpcSslContexts.forClient();
            if (this.cert != null) {
                sslContextBuilder.trustManager((InputStream)new ByteArrayInputStream(this.cert));
            } else {
                sslContextBuilder.trustManager((TrustManagerFactory)new YandexTrustManagerFactory(""));
            }
            return sslContextBuilder.build();
        }
        catch (RuntimeException | SSLException e) {
            throw new RuntimeException("cannot create ssl context", e);
        }
    }

    public static ManagedChannelFactory.Builder build() {
        return new ManagedChannelFactory.Builder(){

            @Override
            public ManagedChannelFactory buildFactory(GrpcTransportBuilder builder) {
                return new NettyChannelFactory(builder);
            }

            public String toString() {
                return "NettyChannelFactory";
            }
        };
    }

    public static ManagedChannelFactory.Builder withInterceptor(final Consumer<NettyChannelBuilder> ci) {
        return builder -> new NettyChannelFactory(builder){

            @Override
            protected void configure(NettyChannelBuilder channelBuilder) {
                if (ci != null) {
                    ci.accept(channelBuilder);
                }
            }
        };
    }
}

