/*
 * Decompiled with CFR 0.152.
 */
package tech.ydb.core.impl.pool;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ScheduledExecutorService;
import java.util.stream.Collectors;
import tech.ydb.core.impl.pool.EndpointRecord;
import tech.ydb.core.impl.pool.GrpcChannel;
import tech.ydb.core.impl.pool.ManagedChannelFactory;
import tech.ydb.shaded.google.common.annotations.VisibleForTesting;
import tech.ydb.shaded.slf4j.Logger;
import tech.ydb.shaded.slf4j.LoggerFactory;

public class GrpcChannelPool {
    private static final Logger logger = LoggerFactory.getLogger(GrpcChannelPool.class);
    private final Map<String, GrpcChannel> channels = new ConcurrentHashMap<String, GrpcChannel>();
    private final ManagedChannelFactory channelFactory;
    private final ScheduledExecutorService executor;

    public GrpcChannelPool(ManagedChannelFactory channelFactory, ScheduledExecutorService executor) {
        this.channelFactory = channelFactory;
        this.executor = executor;
    }

    public GrpcChannel getChannel(EndpointRecord endpoint) {
        GrpcChannel result = this.channels.get(endpoint.getHostAndPort());
        return result != null ? result : this.channels.computeIfAbsent(endpoint.getHostAndPort(), key -> {
            logger.debug("channel " + endpoint.getHostAndPort() + " was not found in pool, creating one...");
            return new GrpcChannel(endpoint, this.channelFactory);
        });
    }

    private CompletableFuture<Boolean> shutdownChannels(Collection<GrpcChannel> channelsToShutdown) {
        if (channelsToShutdown.isEmpty()) {
            return CompletableFuture.completedFuture(Boolean.TRUE);
        }
        logger.debug("shutdown {} channels", (Object)channelsToShutdown.size());
        return CompletableFuture.supplyAsync(() -> {
            int closed = 0;
            for (GrpcChannel channel : channelsToShutdown) {
                if (Thread.currentThread().isInterrupted()) {
                    return false;
                }
                if (!channel.shutdown()) continue;
                ++closed;
            }
            return closed == channelsToShutdown.size();
        }, this.executor);
    }

    public CompletableFuture<Boolean> removeChannels(Collection<EndpointRecord> endpointsToRemove) {
        if (endpointsToRemove == null || endpointsToRemove.isEmpty()) {
            return CompletableFuture.completedFuture(Boolean.TRUE);
        }
        logger.debug("removing {} endpoints from pool: {}", (Object)endpointsToRemove.size(), (Object)endpointsToRemove);
        List<GrpcChannel> channelsToShutdown = endpointsToRemove.stream().map(EndpointRecord::getHostAndPort).map(this.channels::remove).filter(Objects::nonNull).collect(Collectors.toList());
        return this.shutdownChannels(channelsToShutdown);
    }

    public CompletableFuture<Boolean> shutdown() {
        logger.debug("initiating grpc pool shutdown with {} channels...", (Object)this.channels.size());
        return this.shutdownChannels(this.channels.values()).whenComplete((res, th) -> {
            if (res != null && res.booleanValue()) {
                logger.debug("grpc pool was shutdown successfully");
            } else {
                logger.warn("grpc pool was not shutdown properly");
            }
        });
    }

    @VisibleForTesting
    Map<String, GrpcChannel> getChannels() {
        return this.channels;
    }
}

