/*
 * Decompiled with CFR 0.152.
 */
package tech.ydb.core.impl.pool;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import tech.ydb.core.grpc.BalancingSettings;
import tech.ydb.core.impl.pool.EndpointRecord;
import tech.ydb.core.impl.pool.PriorityPicker;
import tech.ydb.shaded.google.common.annotations.VisibleForTesting;
import tech.ydb.shaded.javax.annotation.Nullable;
import tech.ydb.shaded.slf4j.Logger;
import tech.ydb.shaded.slf4j.LoggerFactory;

public final class EndpointPool {
    private static final Logger logger = LoggerFactory.getLogger(EndpointPool.class);
    private static final long DISCOVERY_PESSIMIZATION_THRESHOLD = 50L;
    private final BalancingSettings balancingSettings;
    private final ReadWriteLock recordsLock = new ReentrantReadWriteLock();
    private List<PriorityEndpoint> records = new ArrayList<PriorityEndpoint>();
    private Map<Integer, PriorityEndpoint> recordsByNodeId = new HashMap<Integer, PriorityEndpoint>();
    private Map<String, PriorityEndpoint> recordsByEndpoint = new HashMap<String, PriorityEndpoint>();
    private boolean needToRunDiscovery = false;
    private int bestEndpointsCount = -1;

    public EndpointPool(BalancingSettings balancingSettings) {
        logger.debug("Creating endpoint pool with balancing settings policy: {}", (Object)balancingSettings.getPolicy());
        this.balancingSettings = balancingSettings;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public EndpointRecord getEndpoint(@Nullable Integer preferredNodeID) {
        this.recordsLock.readLock().lock();
        try {
            PriorityEndpoint knownEndpoint;
            if (preferredNodeID != null && (knownEndpoint = this.recordsByNodeId.get(preferredNodeID)) != null) {
                EndpointRecord endpointRecord = knownEndpoint.record;
                return endpointRecord;
            }
            if (this.bestEndpointsCount > 0) {
                int idx = ThreadLocalRandom.current().nextInt(this.bestEndpointsCount);
                EndpointRecord endpointRecord = this.records.get(idx).record;
                return endpointRecord;
            }
            EndpointRecord endpointRecord = null;
            return endpointRecord;
        }
        finally {
            this.recordsLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<EndpointRecord> setNewState(String selfLocation, List<EndpointRecord> endpoints) {
        PriorityPicker picker = PriorityPicker.from(this.balancingSettings, selfLocation, endpoints);
        HashMap<String, PriorityEndpoint> newRecordsByEndpoint = new HashMap<String, PriorityEndpoint>();
        HashMap<Integer, PriorityEndpoint> newRecordsByNodeId = new HashMap<Integer, PriorityEndpoint>();
        ArrayList<PriorityEndpoint> newRecords = new ArrayList<PriorityEndpoint>();
        int newBestEndpointsCount = 0;
        int bestPriority = Integer.MAX_VALUE;
        logger.debug("init new state with {} endpoints", (Object)endpoints.size());
        for (EndpointRecord endpoint : endpoints) {
            int priority = picker.getEndpointPriority(endpoint.getLocation());
            PriorityEndpoint entry = new PriorityEndpoint(endpoint, priority);
            String hostAndPort = endpoint.getHostAndPort();
            if (!newRecordsByEndpoint.containsKey(hostAndPort)) {
                logger.debug("added endpoint {}", (Object)endpoint);
                newRecordsByEndpoint.put(hostAndPort, entry);
                if (endpoint.getNodeId() != 0) {
                    newRecordsByNodeId.put(endpoint.getNodeId(), entry);
                }
                newRecords.add(entry);
                if (priority < bestPriority) {
                    bestPriority = priority;
                    newBestEndpointsCount = 0;
                }
                if (priority != bestPriority) continue;
                ++newBestEndpointsCount;
                continue;
            }
            logger.warn("duplicate endpoint {}", (Object)endpoint.getHostAndPort());
        }
        newRecords.sort(PriorityEndpoint.COMPARATOR);
        ArrayList<EndpointRecord> removed = new ArrayList<EndpointRecord>();
        this.recordsLock.writeLock().lock();
        try {
            for (PriorityEndpoint entry : this.records) {
                if (newRecordsByEndpoint.containsKey(entry.record.getHostAndPort())) continue;
                removed.add(entry.record);
            }
            this.records = newRecords;
            this.recordsByNodeId = newRecordsByNodeId;
            this.recordsByEndpoint = newRecordsByEndpoint;
            this.bestEndpointsCount = newBestEndpointsCount;
            this.needToRunDiscovery = false;
        }
        finally {
            this.recordsLock.writeLock().unlock();
        }
        return removed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void pessimizeEndpoint(EndpointRecord endpoint) {
        if (endpoint == null) {
            return;
        }
        PriorityEndpoint knownEndpoint = this.recordsByEndpoint.get(endpoint.getHostAndPort());
        if (knownEndpoint == null) {
            return;
        }
        if (knownEndpoint.isPessimized()) {
            logger.trace("Endpoint {} is already pessimized", (Object)endpoint);
            return;
        }
        this.recordsLock.writeLock().lock();
        try {
            knownEndpoint.pessimize();
            this.records.sort(PriorityEndpoint.COMPARATOR);
            long bestPriority = this.records.get(0).priority;
            int newBestCount = 0;
            int newPessimizedCount = 0;
            for (PriorityEndpoint record : this.records) {
                if (record.getPriority() == bestPriority) {
                    ++newBestCount;
                }
                if (!record.isPessimized()) continue;
                ++newPessimizedCount;
            }
            this.bestEndpointsCount = newBestCount;
            boolean bl = this.needToRunDiscovery = (long)(100 * newPessimizedCount) > (long)this.records.size() * 50L;
            if (this.needToRunDiscovery) {
                logger.debug("launching discovery due to pessimization threshold is exceeded: {}/{} is more than {}", newPessimizedCount, this.records.size(), 50L);
            }
            logger.trace("Endpoint {} was pessimized. New pessimization ratio: {}/{}", endpoint, newPessimizedCount, this.records.size());
        }
        finally {
            this.recordsLock.writeLock().unlock();
        }
    }

    public boolean needToRunDiscovery() {
        return this.needToRunDiscovery;
    }

    @VisibleForTesting
    Map<Integer, PriorityEndpoint> getEndpointsByNodeId() {
        return this.recordsByNodeId;
    }

    @VisibleForTesting
    List<PriorityEndpoint> getRecords() {
        return this.records;
    }

    @VisibleForTesting
    int getBestEndpointCount() {
        return this.bestEndpointsCount;
    }

    @VisibleForTesting
    static class PriorityEndpoint {
        static final Comparator<PriorityEndpoint> COMPARATOR = Comparator.comparingLong(PriorityEndpoint::getPriority).thenComparing(e -> e.record.getHostAndPort());
        private final EndpointRecord record;
        private long priority;

        PriorityEndpoint(EndpointRecord record, long priority) {
            this.record = record;
            this.priority = priority;
        }

        public long getPriority() {
            return this.priority;
        }

        public EndpointRecord getEndpoint() {
            return this.record;
        }

        public void pessimize() {
            this.priority = Long.MAX_VALUE;
        }

        public boolean isPessimized() {
            return this.priority == Long.MAX_VALUE;
        }
    }
}

