/*
 * Decompiled with CFR 0.152.
 */
package tech.ydb.core.impl.pool;

import tech.ydb.core.impl.pool.ManagedChannelFactory;
import tech.ydb.core.impl.pool.NettyChannelFactory;
import tech.ydb.core.impl.pool.ShadedNettyChannelFactory;
import tech.ydb.shaded.slf4j.Logger;
import tech.ydb.shaded.slf4j.LoggerFactory;

public class ChannelFactoryLoader {
    private static final Logger logger = LoggerFactory.getLogger(ChannelFactoryLoader.class);

    private ChannelFactoryLoader() {
    }

    public static ManagedChannelFactory.Builder load() {
        return FactoryLoader.factory;
    }

    private static class FactoryLoader {
        private static final String SHADED_DEPS = "tech.ydb.shaded.grpc.netty.shaded.io.grpc.netty.NettyChannelBuilder";
        private static final String NETTY_DEPS = "tech.ydb.shaded.grpc.netty.NettyChannelBuilder";
        private static ManagedChannelFactory.Builder factory;

        private FactoryLoader() {
        }

        private static boolean tryLoad(String name, ManagedChannelFactory.Builder f) {
            try {
                Class.forName(name);
                logger.info("class {} is found, use {}", (Object)name, (Object)f);
                factory = f;
                return true;
            }
            catch (ClassNotFoundException ex) {
                logger.info("class {} is not found", (Object)name);
                return false;
            }
        }

        static {
            boolean ok;
            boolean bl = ok = FactoryLoader.tryLoad(SHADED_DEPS, ShadedNettyChannelFactory.build()) || FactoryLoader.tryLoad(NETTY_DEPS, NettyChannelFactory.build());
            if (!ok) {
                throw new IllegalStateException("Cannot load any ManagedChannelFactory!! Classpath must contain grpc-netty or grpc-netty-shaded");
            }
        }
    }
}

