/*
 * Decompiled with CFR 0.152.
 */
package tech.ydb.core.impl.call;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicReference;
import tech.ydb.core.Issue;
import tech.ydb.core.Result;
import tech.ydb.core.Status;
import tech.ydb.core.StatusCode;
import tech.ydb.core.grpc.GrpcStatuses;
import tech.ydb.core.grpc.GrpcTransport;
import tech.ydb.core.impl.call.GrpcStatusHandler;
import tech.ydb.shaded.google.protobuf.Message;
import tech.ydb.shaded.google.protobuf.TextFormat;
import tech.ydb.shaded.grpc.ClientCall;
import tech.ydb.shaded.grpc.Metadata;
import tech.ydb.shaded.javax.annotation.Nullable;
import tech.ydb.shaded.slf4j.Logger;
import tech.ydb.shaded.slf4j.LoggerFactory;

public class UnaryCall<ReqT, RespT>
extends ClientCall.Listener<RespT> {
    private static final Logger logger = LoggerFactory.getLogger(GrpcTransport.class);
    private static final Status NO_VALUE = Status.of(StatusCode.CLIENT_INTERNAL_ERROR).withIssues(Issue.of("No value received for gRPC unary call", Issue.Severity.ERROR));
    private static final Status MULTIPLY_VALUES = Status.of(StatusCode.CLIENT_INTERNAL_ERROR).withIssues(Issue.of("More than one value received for gRPC unary call", Issue.Severity.ERROR));
    private final String traceId;
    private final ClientCall<ReqT, RespT> call;
    private final GrpcStatusHandler statusConsumer;
    private final CompletableFuture<Result<RespT>> future = new CompletableFuture();
    private final AtomicReference<RespT> value = new AtomicReference();

    public UnaryCall(String traceId, ClientCall<ReqT, RespT> call, GrpcStatusHandler statusConsumer) {
        this.traceId = traceId;
        this.call = call;
        this.statusConsumer = statusConsumer;
    }

    public CompletableFuture<Result<RespT>> startCall(ReqT request, Metadata headers) {
        try {
            this.call.start(this, headers);
            this.call.request(1);
            if (logger.isTraceEnabled()) {
                logger.trace("UnaryCall[{}] --> {}", (Object)this.traceId, (Object)TextFormat.shortDebugString((Message)request));
            }
            this.call.sendMessage(request);
            this.call.halfClose();
        }
        catch (Exception ex) {
            this.future.completeExceptionally(ex);
            try {
                this.call.cancel(ex.getMessage(), ex);
            }
            catch (Exception ex2) {
                logger.error("UnaryCall[{}] got exception while canceling", (Object)this.traceId, (Object)ex2);
            }
        }
        return this.future;
    }

    @Override
    public void onMessage(RespT value) {
        if (logger.isTraceEnabled()) {
            logger.trace("UnaryCall[{}] <-- {}", (Object)this.traceId, (Object)TextFormat.shortDebugString((Message)value));
        }
        if (!this.value.compareAndSet(null, value)) {
            this.future.complete(Result.fail(MULTIPLY_VALUES));
        }
    }

    @Override
    public void onClose(tech.ydb.shaded.grpc.Status status, @Nullable Metadata trailers) {
        this.statusConsumer.accept(status, trailers);
        if (logger.isTraceEnabled()) {
            logger.trace("UnaryCall[{}] closed with status {}", (Object)this.traceId, (Object)status);
        }
        if (status.isOk()) {
            RespT snapshotValue = this.value.get();
            if (snapshotValue == null) {
                this.future.complete(Result.fail(NO_VALUE));
            } else {
                this.future.complete(Result.success(snapshotValue));
            }
        } else {
            this.future.complete(GrpcStatuses.toResult(status));
        }
    }
}

