/*
 * Decompiled with CFR 0.152.
 */
package tech.ydb.core.impl.call;

import java.util.ArrayDeque;
import java.util.Queue;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicReference;
import tech.ydb.core.Status;
import tech.ydb.core.grpc.GrpcReadStream;
import tech.ydb.core.grpc.GrpcReadWriteStream;
import tech.ydb.core.grpc.GrpcStatuses;
import tech.ydb.core.grpc.GrpcTransport;
import tech.ydb.core.impl.auth.AuthCallOptions;
import tech.ydb.core.impl.call.GrpcStatusHandler;
import tech.ydb.shaded.google.protobuf.Message;
import tech.ydb.shaded.google.protobuf.TextFormat;
import tech.ydb.shaded.grpc.ClientCall;
import tech.ydb.shaded.grpc.Metadata;
import tech.ydb.shaded.javax.annotation.Nullable;
import tech.ydb.shaded.slf4j.Logger;
import tech.ydb.shaded.slf4j.LoggerFactory;

public class ReadWriteStreamCall<R, W>
extends ClientCall.Listener<R>
implements GrpcReadWriteStream<R, W> {
    private static final Logger logger = LoggerFactory.getLogger(GrpcTransport.class);
    private final String traceId;
    private final ClientCall<W, R> call;
    private final GrpcStatusHandler statusConsumer;
    private final Metadata headers;
    private final AuthCallOptions callOptions;
    private final CompletableFuture<Status> statusFuture = new CompletableFuture();
    private final AtomicReference<GrpcReadStream.Observer<R>> observerReference = new AtomicReference();
    private final Queue<W> messagesQueue = new ArrayDeque<W>();

    public ReadWriteStreamCall(String traceId, ClientCall<W, R> call, Metadata headers, AuthCallOptions callOptions, GrpcStatusHandler statusConsumer) {
        this.traceId = traceId;
        this.call = call;
        this.headers = headers;
        this.statusConsumer = statusConsumer;
        this.callOptions = callOptions;
    }

    @Override
    public String authToken() {
        return this.callOptions.getToken();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CompletableFuture<Status> start(GrpcReadStream.Observer<R> observer) {
        if (!this.observerReference.compareAndSet(null, observer)) {
            throw new IllegalStateException("Read stream call is already started");
        }
        ClientCall<W, R> clientCall = this.call;
        synchronized (clientCall) {
            try {
                this.call.start(this, this.headers);
                this.call.request(1);
            }
            catch (Throwable t) {
                try {
                    this.call.cancel(null, t);
                }
                catch (Throwable ex) {
                    logger.error("Exception encountered while closing the unary call", ex);
                }
                this.statusFuture.completeExceptionally(t);
            }
        }
        return this.statusFuture;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void sendNext(W message) {
        ClientCall<W, R> clientCall = this.call;
        synchronized (clientCall) {
            if (this.flush()) {
                this.call.sendMessage(message);
            } else {
                this.messagesQueue.add(message);
            }
        }
    }

    private boolean flush() {
        while (this.call.isReady()) {
            W next = this.messagesQueue.poll();
            if (next == null) {
                return true;
            }
            if (logger.isTraceEnabled()) {
                logger.trace("ReadWriteStreamCall[{}] --> {}", (Object)this.traceId, (Object)TextFormat.shortDebugString((Message)next));
            }
            this.call.sendMessage(next);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void cancel() {
        ClientCall<W, R> clientCall = this.call;
        synchronized (clientCall) {
            this.call.cancel("Cancelled on user request", new CancellationException());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onMessage(R message) {
        try {
            if (logger.isTraceEnabled()) {
                logger.trace("ReadWriteStreamCall[{}] <-- {}", (Object)this.traceId, (Object)TextFormat.shortDebugString((Message)message));
            }
            this.observerReference.get().onNext(message);
            ClientCall<W, R> clientCall = this.call;
            synchronized (clientCall) {
                this.call.request(1);
            }
        }
        catch (Exception ex) {
            this.statusFuture.completeExceptionally(ex);
            try {
                ClientCall<W, R> clientCall = this.call;
                synchronized (clientCall) {
                    this.call.cancel("Canceled by exception from observer", ex);
                }
            }
            catch (Throwable th) {
                logger.error("Exception encountered while canceling the read write stream call", th);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onReady() {
        ClientCall<W, R> clientCall = this.call;
        synchronized (clientCall) {
            this.flush();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        ClientCall<W, R> clientCall = this.call;
        synchronized (clientCall) {
            this.call.halfClose();
        }
    }

    @Override
    public void onClose(tech.ydb.shaded.grpc.Status status, @Nullable Metadata trailers) {
        if (logger.isTraceEnabled()) {
            logger.trace("ReadWriteStreamCall[{}] closed with status {}", (Object)status);
        }
        this.statusConsumer.accept(status, trailers);
        if (status.isOk()) {
            this.statusFuture.complete(Status.SUCCESS);
        } else {
            this.statusFuture.complete(GrpcStatuses.toStatus(status));
        }
    }
}

