/*
 * Decompiled with CFR 0.152.
 */
package tech.ydb.core.impl.call;

import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicReference;
import tech.ydb.core.Status;
import tech.ydb.core.grpc.GrpcReadStream;
import tech.ydb.core.grpc.GrpcStatuses;
import tech.ydb.core.grpc.GrpcTransport;
import tech.ydb.core.impl.call.GrpcStatusHandler;
import tech.ydb.shaded.google.protobuf.Message;
import tech.ydb.shaded.google.protobuf.TextFormat;
import tech.ydb.shaded.grpc.ClientCall;
import tech.ydb.shaded.grpc.Metadata;
import tech.ydb.shaded.javax.annotation.Nullable;
import tech.ydb.shaded.slf4j.Logger;
import tech.ydb.shaded.slf4j.LoggerFactory;

public class ReadStreamCall<ReqT, RespT>
extends ClientCall.Listener<RespT>
implements GrpcReadStream<RespT> {
    private static final Logger logger = LoggerFactory.getLogger(GrpcTransport.class);
    private final String traceId;
    private final ClientCall<ReqT, RespT> call;
    private final GrpcStatusHandler statusConsumer;
    private final ReqT request;
    private final Metadata headers;
    private final CompletableFuture<Status> statusFuture = new CompletableFuture();
    private final AtomicReference<GrpcReadStream.Observer<RespT>> observerReference = new AtomicReference();

    public ReadStreamCall(String traceId, ClientCall<ReqT, RespT> call, ReqT request, Metadata headers, GrpcStatusHandler statusConsumer) {
        this.traceId = traceId;
        this.call = call;
        this.request = request;
        this.headers = headers;
        this.statusConsumer = statusConsumer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CompletableFuture<Status> start(GrpcReadStream.Observer<RespT> observer) {
        if (!this.observerReference.compareAndSet(null, observer)) {
            throw new IllegalStateException("Read stream call is already started");
        }
        ClientCall<ReqT, RespT> clientCall = this.call;
        synchronized (clientCall) {
            try {
                this.call.start(this, this.headers);
                this.call.request(1);
                if (logger.isTraceEnabled()) {
                    logger.trace("ReadStreamCall[{}] --> {}", (Object)this.traceId, (Object)TextFormat.shortDebugString((Message)this.request));
                }
                this.call.sendMessage(this.request);
                this.call.halfClose();
            }
            catch (Throwable t) {
                try {
                    this.call.cancel(null, t);
                }
                catch (Throwable ex) {
                    logger.error("ReadStreamCall[{}] got exception while canceling", (Object)this.traceId, (Object)ex);
                }
                this.statusFuture.completeExceptionally(t);
            }
        }
        return this.statusFuture;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void cancel() {
        ClientCall<ReqT, RespT> clientCall = this.call;
        synchronized (clientCall) {
            this.call.cancel("Cancelled on user request", new CancellationException());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onMessage(RespT message) {
        try {
            if (logger.isTraceEnabled()) {
                logger.trace("ReadStreamCall[{}] <-- {}", (Object)this.traceId, (Object)TextFormat.shortDebugString((Message)message));
            }
            this.observerReference.get().onNext(message);
            ClientCall<ReqT, RespT> clientCall = this.call;
            synchronized (clientCall) {
                this.call.request(1);
            }
        }
        catch (Exception ex) {
            this.statusFuture.completeExceptionally(ex);
            try {
                ClientCall<ReqT, RespT> clientCall = this.call;
                synchronized (clientCall) {
                    this.call.cancel("Canceled by exception from observer", ex);
                }
            }
            catch (Throwable th) {
                logger.error("ReadStreamCall[{}] got exception while canceling", (Object)this.traceId, (Object)th);
            }
        }
    }

    @Override
    public void onClose(tech.ydb.shaded.grpc.Status status, @Nullable Metadata trailers) {
        if (logger.isTraceEnabled()) {
            logger.trace("ReadStreamCall[{}] closed with status {}", (Object)this.traceId, (Object)status);
        }
        this.statusConsumer.accept(status, trailers);
        if (status.isOk()) {
            this.statusFuture.complete(Status.SUCCESS);
        } else {
            this.statusFuture.complete(GrpcStatuses.toStatus(status));
        }
    }
}

