/*
 * Decompiled with CFR 0.152.
 */
package tech.ydb.core.impl.auth;

import java.util.concurrent.Executor;
import tech.ydb.auth.AuthIdentity;
import tech.ydb.shaded.grpc.CallCredentials;
import tech.ydb.shaded.grpc.Metadata;
import tech.ydb.shaded.grpc.Status;
import tech.ydb.shaded.slf4j.Logger;
import tech.ydb.shaded.slf4j.LoggerFactory;

class YdbCallCredentials
extends CallCredentials {
    static final Metadata.Key<String> AUTH_TICKET = Metadata.Key.of("x-ydb-auth-ticket", Metadata.ASCII_STRING_MARSHALLER);
    private static final Logger logger = LoggerFactory.getLogger(YdbCallCredentials.class);
    private final AuthIdentity identity;

    YdbCallCredentials(AuthIdentity identity) {
        this.identity = identity;
    }

    @Override
    public void applyRequestMetadata(CallCredentials.RequestInfo requestInfo, Executor appExecutor, CallCredentials.MetadataApplier applier) {
        try {
            Metadata headers = new Metadata();
            String token = this.identity.getToken();
            if (token != null) {
                headers.put(AUTH_TICKET, token);
            }
            applier.apply(headers);
        }
        catch (Exception ex) {
            logger.error("unexpected exception ", ex);
            applier.fail(Status.INTERNAL.withDescription("get token exception").withCause(ex));
        }
    }
}

