/*
 * Decompiled with CFR 0.152.
 */
package tech.ydb.core.impl.auth;

import java.util.List;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import tech.ydb.auth.AuthIdentity;
import tech.ydb.auth.AuthRpcProvider;
import tech.ydb.core.grpc.GrpcCompression;
import tech.ydb.core.grpc.GrpcTransportBuilder;
import tech.ydb.core.impl.auth.GrpcAuthRpc;
import tech.ydb.core.impl.auth.YdbCallCredentials;
import tech.ydb.core.impl.pool.EndpointRecord;
import tech.ydb.core.impl.pool.ManagedChannelFactory;
import tech.ydb.shaded.google.common.util.concurrent.MoreExecutors;
import tech.ydb.shaded.grpc.CallOptions;

public class AuthCallOptions
implements AutoCloseable {
    private final AuthIdentity authIdentity;
    private final CallOptions callOptions;
    private final long readTimeoutMillis;

    public AuthCallOptions() {
        this.authIdentity = null;
        this.callOptions = CallOptions.DEFAULT;
        this.readTimeoutMillis = 0L;
    }

    public AuthCallOptions(ScheduledExecutorService scheduler, List<EndpointRecord> endpoints, ManagedChannelFactory channelFactory, GrpcTransportBuilder builder) {
        CallOptions options = CallOptions.DEFAULT;
        AuthRpcProvider<? super GrpcAuthRpc> authProvider = builder.getAuthProvider();
        if (authProvider != null) {
            GrpcAuthRpc rpc = new GrpcAuthRpc(endpoints, scheduler, builder.getDatabase(), channelFactory);
            this.authIdentity = builder.getAuthProvider().createAuthIdentity(rpc);
        } else {
            this.authIdentity = null;
        }
        if (this.authIdentity != null) {
            options = options.withCallCredentials(new YdbCallCredentials(this.authIdentity));
        }
        if (builder.getCallExecutor() != null && builder.getCallExecutor() != MoreExecutors.directExecutor()) {
            options = options.withExecutor(builder.getCallExecutor());
        }
        if (builder.getGrpcCompression() != GrpcCompression.NO_COMPRESSION) {
            options = options.withCompression(builder.getGrpcCompression().compressor());
        }
        this.callOptions = options;
        this.readTimeoutMillis = builder.getReadTimeoutMillis();
    }

    @Override
    public void close() {
        if (this.authIdentity != null) {
            this.authIdentity.close();
        }
    }

    public String getToken() {
        if (this.authIdentity != null) {
            return this.authIdentity.getToken();
        }
        return null;
    }

    public CallOptions getGrpcCallOptions() {
        if (this.readTimeoutMillis > 0L) {
            return this.callOptions.withDeadlineAfter(this.readTimeoutMillis, TimeUnit.MILLISECONDS);
        }
        return this.callOptions;
    }
}

