/*
 * Decompiled with CFR 0.152.
 */
package tech.ydb.core.impl;

import java.util.concurrent.ScheduledExecutorService;
import tech.ydb.core.grpc.GrpcRequestSettings;
import tech.ydb.core.impl.BaseGrpcTransport;
import tech.ydb.core.impl.auth.AuthCallOptions;
import tech.ydb.core.impl.pool.EndpointRecord;
import tech.ydb.core.impl.pool.GrpcChannel;
import tech.ydb.core.impl.pool.ManagedChannelFactory;
import tech.ydb.shaded.grpc.Status;
import tech.ydb.shaded.slf4j.Logger;
import tech.ydb.shaded.slf4j.LoggerFactory;

public class FixedCallOptionsTransport
extends BaseGrpcTransport {
    private static final Logger logger = LoggerFactory.getLogger(FixedCallOptionsTransport.class);
    private final ScheduledExecutorService scheduler;
    private final AuthCallOptions callOptions;
    private final String database;
    private final GrpcChannel channel;

    public FixedCallOptionsTransport(ScheduledExecutorService scheduler, AuthCallOptions callOptions, String database, EndpointRecord endpoint, ManagedChannelFactory channelFactory) {
        this.scheduler = scheduler;
        this.callOptions = callOptions;
        this.database = database;
        this.channel = new GrpcChannel(endpoint, channelFactory);
    }

    @Override
    public ScheduledExecutorService getScheduler() {
        return this.scheduler;
    }

    @Override
    public String getDatabase() {
        return this.database;
    }

    @Override
    protected void shutdown() {
        this.channel.shutdown();
    }

    @Override
    public AuthCallOptions getAuthCallOptions() {
        return this.callOptions;
    }

    @Override
    protected GrpcChannel getChannel(GrpcRequestSettings settings) {
        return this.channel;
    }

    @Override
    protected void updateChannelStatus(GrpcChannel channel, Status status) {
        if (!status.isOk()) {
            logger.warn("grpc error {}[{}] on fixed channel {}", new Object[]{status.getCode(), status.getDescription(), channel.getEndpoint()});
        }
    }
}

