/*
 * Decompiled with CFR 0.152.
 */
package tech.ydb.core.impl;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import tech.ydb.core.Issue;
import tech.ydb.core.Result;
import tech.ydb.core.Status;
import tech.ydb.core.StatusCode;
import tech.ydb.core.UnexpectedResultException;
import tech.ydb.core.grpc.GrpcReadStream;
import tech.ydb.core.grpc.GrpcReadWriteStream;
import tech.ydb.core.grpc.GrpcRequestSettings;
import tech.ydb.core.grpc.GrpcStatuses;
import tech.ydb.core.grpc.GrpcTransport;
import tech.ydb.core.grpc.YdbHeaders;
import tech.ydb.core.impl.auth.AuthCallOptions;
import tech.ydb.core.impl.call.EmptyStream;
import tech.ydb.core.impl.call.GrpcStatusHandler;
import tech.ydb.core.impl.call.ReadStreamCall;
import tech.ydb.core.impl.call.ReadWriteStreamCall;
import tech.ydb.core.impl.call.UnaryCall;
import tech.ydb.core.impl.pool.GrpcChannel;
import tech.ydb.shaded.grpc.CallOptions;
import tech.ydb.shaded.grpc.ClientCall;
import tech.ydb.shaded.grpc.Metadata;
import tech.ydb.shaded.grpc.MethodDescriptor;
import tech.ydb.shaded.slf4j.Logger;
import tech.ydb.shaded.slf4j.LoggerFactory;

public abstract class BaseGrpcTransport
implements GrpcTransport {
    private static final Logger logger = LoggerFactory.getLogger(GrpcTransport.class);
    private static final Result<?> SHUTDOWN_RESULT = Result.fail(Status.of(StatusCode.CLIENT_CANCELLED).withIssues(Issue.of("Request was not sent: transport is shutting down", Issue.Severity.ERROR)));
    private final AtomicBoolean isClosed = new AtomicBoolean(false);

    protected abstract AuthCallOptions getAuthCallOptions();

    protected abstract GrpcChannel getChannel(GrpcRequestSettings var1);

    protected abstract void updateChannelStatus(GrpcChannel var1, tech.ydb.shaded.grpc.Status var2);

    protected void shutdown() {
    }

    @Override
    public void close() {
        if (this.isClosed.compareAndSet(false, true)) {
            this.shutdown();
        }
    }

    @Override
    public <ReqT, RespT> CompletableFuture<Result<RespT>> unaryCall(MethodDescriptor<ReqT, RespT> method, GrpcRequestSettings settings, ReqT request) {
        if (this.isClosed.get()) {
            return CompletableFuture.completedFuture(SHUTDOWN_RESULT.map(null));
        }
        String traceId = settings.getTraceId();
        CallOptions options = this.getAuthCallOptions().getGrpcCallOptions();
        if (settings.getDeadlineAfter() != 0L) {
            long now = System.nanoTime();
            if (now >= settings.getDeadlineAfter()) {
                return CompletableFuture.completedFuture(BaseGrpcTransport.deadlineExpiredResult(method, settings));
            }
            options = options.withDeadlineAfter(settings.getDeadlineAfter() - now, TimeUnit.NANOSECONDS);
        }
        try {
            GrpcChannel channel = this.getChannel(settings);
            ClientCall<ReqT, RespT> call = channel.getReadyChannel().newCall(method, options);
            ChannelStatusHandler handler = new ChannelStatusHandler(channel, settings);
            if (logger.isTraceEnabled()) {
                logger.trace("UnaryCall[{}] with method {} and endpoint {} created", traceId, method.getFullMethodName(), channel.getEndpoint().getHostAndPort());
            }
            return new UnaryCall<ReqT, RespT>(traceId, call, handler).startCall(request, this.makeMetadataFromSettings(settings));
        }
        catch (UnexpectedResultException ex) {
            logger.error("UnaryCall[{}] got unexprected status {}", (Object)traceId, (Object)ex.getStatus());
            return CompletableFuture.completedFuture(Result.fail(ex));
        }
        catch (RuntimeException ex) {
            logger.error("UnaryCall[{}] got problem {}", (Object)traceId, (Object)ex.getMessage());
            return CompletableFuture.completedFuture(Result.error(ex.getMessage(), ex));
        }
    }

    @Override
    public <ReqT, RespT> GrpcReadStream<RespT> readStreamCall(MethodDescriptor<ReqT, RespT> method, GrpcRequestSettings settings, ReqT request) {
        if (this.isClosed.get()) {
            return new EmptyStream(SHUTDOWN_RESULT.getStatus());
        }
        String traceId = settings.getTraceId();
        CallOptions options = this.getAuthCallOptions().getGrpcCallOptions();
        if (settings.getDeadlineAfter() != 0L) {
            long now = System.nanoTime();
            if (now >= settings.getDeadlineAfter()) {
                return new EmptyStream(GrpcStatuses.toStatus(BaseGrpcTransport.deadlineExpiredStatus(method, settings)));
            }
            options = options.withDeadlineAfter(settings.getDeadlineAfter() - now, TimeUnit.NANOSECONDS);
        }
        try {
            GrpcChannel channel = this.getChannel(settings);
            ClientCall<ReqT, RespT> call = channel.getReadyChannel().newCall(method, options);
            ChannelStatusHandler handler = new ChannelStatusHandler(channel, settings);
            if (logger.isTraceEnabled()) {
                logger.trace("ReadStreamCall[{}] with method {} and endpoint {} created", traceId, method.getFullMethodName(), channel.getEndpoint().getHostAndPort());
            }
            return new ReadStreamCall<ReqT, RespT>(traceId, call, request, this.makeMetadataFromSettings(settings), handler);
        }
        catch (UnexpectedResultException ex) {
            logger.error("ReadStreamCall[{}] got unexpected status {}", (Object)traceId, (Object)ex.getStatus());
            return new EmptyStream(ex.getStatus());
        }
        catch (RuntimeException ex) {
            logger.error("ReadStreamCall[{}] got problem {}", (Object)traceId, (Object)ex.getMessage());
            Issue issue = Issue.of(ex.getMessage(), Issue.Severity.ERROR);
            return new EmptyStream(Status.of(StatusCode.CLIENT_INTERNAL_ERROR, issue));
        }
    }

    @Override
    public <ReqT, RespT> GrpcReadWriteStream<RespT, ReqT> readWriteStreamCall(MethodDescriptor<ReqT, RespT> method, GrpcRequestSettings settings) {
        if (this.isClosed.get()) {
            return new EmptyStream(SHUTDOWN_RESULT.getStatus());
        }
        String traceId = settings.getTraceId();
        CallOptions options = this.getAuthCallOptions().getGrpcCallOptions();
        if (settings.getDeadlineAfter() != 0L) {
            long now = System.nanoTime();
            if (now >= settings.getDeadlineAfter()) {
                return new EmptyStream(GrpcStatuses.toStatus(BaseGrpcTransport.deadlineExpiredStatus(method, settings)));
            }
            options = options.withDeadlineAfter(settings.getDeadlineAfter() - now, TimeUnit.NANOSECONDS);
        }
        try {
            GrpcChannel channel = this.getChannel(settings);
            ClientCall<ReqT, RespT> call = channel.getReadyChannel().newCall(method, options);
            ChannelStatusHandler handler = new ChannelStatusHandler(channel, settings);
            if (logger.isTraceEnabled()) {
                logger.trace("ReadWriteStreamCall[{}] with method {} and endpoint {} created", traceId, method.getFullMethodName(), channel.getEndpoint().getHostAndPort());
            }
            return new ReadWriteStreamCall<RespT, ReqT>(traceId, call, this.makeMetadataFromSettings(settings), this.getAuthCallOptions(), handler);
        }
        catch (UnexpectedResultException ex) {
            logger.error("ReadWriteStreamCall[{}] got unexpected status {}", (Object)traceId, (Object)ex.getStatus());
            return new EmptyStream(ex.getStatus());
        }
        catch (RuntimeException ex) {
            logger.error("ReadWriteStreamCall[{}] got problem {}", (Object)traceId, (Object)ex.getMessage());
            Issue issue = Issue.of(ex.getMessage(), Issue.Severity.ERROR);
            return new EmptyStream(Status.of(StatusCode.CLIENT_INTERNAL_ERROR, issue));
        }
    }

    private static <T> Result<T> deadlineExpiredResult(MethodDescriptor<?, T> method, GrpcRequestSettings settings) {
        String message = "deadline expired before calling method " + method.getFullMethodName() + " with traceId " + settings.getTraceId();
        return Result.fail(Status.of(StatusCode.CLIENT_DEADLINE_EXPIRED, Issue.of(message, Issue.Severity.ERROR)));
    }

    private static tech.ydb.shaded.grpc.Status deadlineExpiredStatus(MethodDescriptor<?, ?> method, GrpcRequestSettings settings) {
        String message = "deadline expired before calling method " + method.getFullMethodName() + " with traceId " + settings.getTraceId();
        return tech.ydb.shaded.grpc.Status.DEADLINE_EXCEEDED.withDescription(message);
    }

    private Metadata makeMetadataFromSettings(GrpcRequestSettings settings) {
        Metadata metadata = new Metadata();
        if (settings.getTraceId() != null) {
            metadata.put(YdbHeaders.TRACE_ID, settings.getTraceId());
        }
        if (settings.getClientCapabilities() != null) {
            settings.getClientCapabilities().forEach(name -> metadata.put(YdbHeaders.YDB_CLIENT_CAPABILITIES, name));
        }
        return metadata;
    }

    private class ChannelStatusHandler
    implements GrpcStatusHandler {
        private final GrpcChannel channel;
        private final GrpcRequestSettings settings;

        ChannelStatusHandler(GrpcChannel channel, GrpcRequestSettings settings) {
            this.channel = channel;
            this.settings = settings;
        }

        @Override
        public void accept(tech.ydb.shaded.grpc.Status status, Metadata trailers) {
            BaseGrpcTransport.this.updateChannelStatus(this.channel, status);
            if (this.settings.getTrailersHandler() != null && trailers != null) {
                this.settings.getTrailersHandler().accept(trailers);
            }
        }
    }
}

