/*
 * Decompiled with CFR 0.152.
 */
package tech.ydb.core.grpc;

import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import tech.ydb.shaded.grpc.Metadata;

public class GrpcRequestSettings {
    private final long deadlineAfter;
    private final Integer preferredNodeID;
    private final String traceId;
    private final List<String> clientCapabilities;
    private final Consumer<Metadata> trailersHandler;

    private GrpcRequestSettings(Builder builder) {
        this.deadlineAfter = builder.deadlineAfter;
        this.preferredNodeID = builder.preferredNodeID;
        this.traceId = builder.traceId;
        this.clientCapabilities = builder.clientCapabilities;
        this.trailersHandler = builder.trailersHandler;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public long getDeadlineAfter() {
        return this.deadlineAfter;
    }

    public Integer getPreferredNodeID() {
        return this.preferredNodeID;
    }

    public String getTraceId() {
        return this.traceId;
    }

    public List<String> getClientCapabilities() {
        return this.clientCapabilities;
    }

    public Consumer<Metadata> getTrailersHandler() {
        return this.trailersHandler;
    }

    public static final class Builder {
        private long deadlineAfter = 0L;
        private Integer preferredNodeID = null;
        private String traceId = null;
        private List<String> clientCapabilities = null;
        private Consumer<Metadata> trailersHandler = null;

        public Builder withDeadlineAfter(long deadlineAfter) {
            this.deadlineAfter = deadlineAfter;
            return this;
        }

        public Builder withDeadline(Duration duration) {
            this.deadlineAfter = duration != null && !duration.isZero() ? System.nanoTime() + duration.toNanos() : 0L;
            return this;
        }

        public Builder withPreferredNodeID(Integer preferredNodeID) {
            this.preferredNodeID = preferredNodeID;
            return this;
        }

        public Builder withTraceId(String traceId) {
            this.traceId = traceId;
            return this;
        }

        public Builder withClientCapabilities(List<String> clientCapabilities) {
            this.clientCapabilities = clientCapabilities;
            return this;
        }

        public Builder addClientCapability(String clientCapability) {
            if (this.clientCapabilities == null) {
                this.clientCapabilities = new ArrayList<String>();
            }
            this.clientCapabilities.add(clientCapability);
            return this;
        }

        public Builder withTrailersHandler(Consumer<Metadata> handler) {
            this.trailersHandler = handler;
            return this;
        }

        public GrpcRequestSettings build() {
            return new GrpcRequestSettings(this);
        }
    }
}

