package tech.ydb.jdbc;

import java.sql.Connection;
import java.sql.SQLException;

import javax.annotation.Nullable;

import tech.ydb.jdbc.context.YdbContext;
import tech.ydb.jdbc.context.YdbExecutor;

public interface YdbConnection extends Connection {
    @Nullable
    String getYdbTxId() throws SQLException;

    YdbContext getCtx();

    YdbExecutor getExecutor();

    @Override
    YdbDatabaseMetaData getMetaData() throws SQLException;

    @Override
    YdbStatement createStatement() throws SQLException;

    @Override
    YdbStatement createStatement(int resultSetType, int resultSetConcurrency) throws SQLException;

    @Override
    YdbPreparedStatement prepareStatement(String sql, int resultSetType,
                                          int resultSetConcurrency) throws SQLException;

    @Override
    YdbStatement createStatement(int resultSetType, int resultSetConcurrency,
                                 int resultSetHoldability) throws SQLException;

    @Override
    YdbPreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency,
                                          int resultSetHoldability) throws SQLException;

    @Override
    YdbPreparedStatement prepareStatement(String sql, int autoGeneratedKeys) throws SQLException;

    @Override
    YdbPreparedStatement prepareStatement(String sql, int[] columnIndexes) throws SQLException;

    @Override
    YdbPreparedStatement prepareStatement(String sql, String[] columnNames) throws SQLException;


    /**
     * Prepares statement depending on driver settings
     *
     * @param sql sql to execute
     * @return statement
     * @throws SQLException in case of any internal error
     */
    @Override
    YdbPreparedStatement prepareStatement(String sql) throws SQLException;

    /**
     * Prepares statement with explicit configuration
     *
     * @param sql  sql to prepare
     * @param mode prepare mode
     * @return prepared statement
     * @throws SQLException in case of any internal error
     */
    YdbPreparedStatement prepareStatement(String sql, YdbPrepareMode mode) throws SQLException;
}
