/*
 * Decompiled with CFR 0.152.
 */
package yandex.cloud.sdk.auth.jwt;

import java.time.Duration;
import java.util.Objects;

public class JwtConfig {
    private final String endpoint;
    private final Duration ttl;

    private JwtConfig(String endpoint, Duration ttl) {
        this.endpoint = endpoint;
        this.ttl = ttl;
    }

    public JwtConfigBuilder builder() {
        return new JwtConfigBuilder();
    }

    public String getEndpoint() {
        return this.endpoint;
    }

    public Duration getTtl() {
        return this.ttl;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        JwtConfig jwtConfig = (JwtConfig)o;
        return Objects.equals(this.endpoint, jwtConfig.endpoint) && Objects.equals(this.ttl, jwtConfig.ttl);
    }

    public String toString() {
        return "JwtConfig{endpoint='" + this.endpoint + '\'' + ", ttl=" + this.ttl + '}';
    }

    public int hashCode() {
        return Objects.hash(this.endpoint, this.ttl);
    }

    public static class JwtConfigBuilder {
        private String endpoint;
        private Duration ttl;

        private JwtConfigBuilder() {
        }

        public JwtConfigBuilder endpoint(String endpoint) {
            this.endpoint = endpoint;
            return this;
        }

        public JwtConfigBuilder ttl(Duration ttl) {
            this.ttl = ttl;
            return this;
        }

        public JwtConfig build() {
            return new JwtConfig(this.endpoint, this.ttl);
        }
    }
}

