/*
 * Decompiled with CFR 0.152.
 */
package tech.ydb.table.transaction;

import tech.ydb.proto.table.YdbTable;
import tech.ydb.table.transaction.Transaction;

public abstract class TxControl<Self extends TxControl<?>> {
    private final YdbTable.TransactionControl pb;

    protected TxControl(boolean commitTx, String id) {
        this.pb = YdbTable.TransactionControl.newBuilder().setCommitTx(commitTx).setTxId(id).build();
    }

    protected TxControl(boolean commitTx, YdbTable.TransactionSettings settings) {
        this.pb = YdbTable.TransactionControl.newBuilder().setCommitTx(commitTx).setBeginTx(settings).build();
    }

    public static TxId id(String id) {
        return new TxId(true, id);
    }

    public static TxId id(Transaction tx) {
        return new TxId(true, tx.getId());
    }

    public static TxSerializableRw serializableRw() {
        return TxSerializableRw.WITH_COMMIT;
    }

    public static TxSnapshotRo snapshotRo() {
        return TxSnapshotRo.WITH_COMMIT;
    }

    public static TxStaleRo staleRo() {
        return TxStaleRo.WITH_COMMIT;
    }

    public static TxOnlineRo onlineRo() {
        return TxOnlineRo.WITH_COMMIT;
    }

    public boolean isCommitTx() {
        return this.pb.getCommitTx();
    }

    public abstract Self setCommitTx(boolean var1);

    public YdbTable.TransactionControl toPb() {
        return this.pb;
    }

    public static final class TxSnapshotRo
    extends TxControl<TxSnapshotRo> {
        private static final TxSnapshotRo WITH_COMMIT = new TxSnapshotRo(true);
        private static final TxSnapshotRo WITHOUT_COMMIT = new TxSnapshotRo(false);

        TxSnapshotRo(boolean commitTx) {
            super(commitTx, YdbTable.TransactionSettings.newBuilder().setSnapshotReadOnly(YdbTable.SnapshotModeSettings.newBuilder().build()).build());
        }

        @Override
        public TxSnapshotRo setCommitTx(boolean commitTx) {
            if (commitTx == this.isCommitTx()) {
                return this;
            }
            return commitTx ? WITH_COMMIT : WITHOUT_COMMIT;
        }
    }

    public static final class TxOnlineRo
    extends TxControl<TxOnlineRo> {
        private static final TxOnlineRo WITH_COMMIT = new TxOnlineRo(true, false);
        private static final TxOnlineRo WITHOUT_COMMIT = new TxOnlineRo(false, false);
        private final boolean allowInconsistentReads;

        TxOnlineRo(boolean commitTx, boolean allowInconsistentReads) {
            super(commitTx, YdbTable.TransactionSettings.newBuilder().setOnlineReadOnly(YdbTable.OnlineModeSettings.newBuilder().setAllowInconsistentReads(allowInconsistentReads)).build());
            this.allowInconsistentReads = allowInconsistentReads;
        }

        public boolean isAllowInconsistentReads() {
            return this.allowInconsistentReads;
        }

        public TxOnlineRo setAllowInconsistentReads(boolean allowInconsistentReads) {
            if (allowInconsistentReads == this.isAllowInconsistentReads()) {
                return this;
            }
            return new TxOnlineRo(this.isCommitTx(), allowInconsistentReads);
        }

        @Override
        public TxOnlineRo setCommitTx(boolean commitTx) {
            if (commitTx == this.isCommitTx()) {
                return this;
            }
            if (this.allowInconsistentReads) {
                return new TxOnlineRo(commitTx, true);
            }
            return commitTx ? WITH_COMMIT : WITHOUT_COMMIT;
        }
    }

    public static final class TxStaleRo
    extends TxControl<TxStaleRo> {
        private static final TxStaleRo WITH_COMMIT = new TxStaleRo(true);
        private static final TxStaleRo WITHOUT_COMMIT = new TxStaleRo(false);

        TxStaleRo(boolean commitTx) {
            super(commitTx, YdbTable.TransactionSettings.newBuilder().setStaleReadOnly(YdbTable.StaleModeSettings.getDefaultInstance()).build());
        }

        @Override
        public TxStaleRo setCommitTx(boolean commitTx) {
            return commitTx ? WITH_COMMIT : WITHOUT_COMMIT;
        }
    }

    public static final class TxSerializableRw
    extends TxControl<TxSerializableRw> {
        private static final TxSerializableRw WITH_COMMIT = new TxSerializableRw(true);
        private static final TxSerializableRw WITHOUT_COMMIT = new TxSerializableRw(false);

        TxSerializableRw(boolean commitTx) {
            super(commitTx, YdbTable.TransactionSettings.newBuilder().setSerializableReadWrite(YdbTable.SerializableModeSettings.getDefaultInstance()).build());
        }

        @Override
        public TxSerializableRw setCommitTx(boolean commitTx) {
            return commitTx ? WITH_COMMIT : WITHOUT_COMMIT;
        }
    }

    public static final class TxId
    extends TxControl<TxId> {
        private final String id;

        TxId(boolean commitTx, String id) {
            super(commitTx, id);
            this.id = id;
        }

        @Override
        public TxId setCommitTx(boolean commitTx) {
            return commitTx == this.isCommitTx() ? this : new TxId(commitTx, this.id);
        }
    }
}

