/*
 * Decompiled with CFR 0.152.
 */
package tech.ydb.table.settings;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import tech.ydb.table.settings.Changefeed;
import tech.ydb.table.settings.PartitioningSettings;
import tech.ydb.table.settings.RequestSettings;
import tech.ydb.table.settings.TtlSettings;
import tech.ydb.table.values.Type;

public class AlterTableSettings
extends RequestSettings<AlterTableSettings> {
    private final LinkedHashMap<String, Type> addColumns = new LinkedHashMap();
    private final HashSet<String> dropColumns = new HashSet();
    @Nullable
    private TtlSettings ttlSettings;
    @Nullable
    private PartitioningSettings partitioningSettings;
    private final List<Changefeed> addChangefeeds = new ArrayList<Changefeed>();
    private final List<String> dropChangefeeds = new ArrayList<String>();

    public AlterTableSettings addColumn(String name, Type type) {
        this.addColumns.put(name, type);
        return this;
    }

    public AlterTableSettings dropColumn(String name) {
        this.dropColumns.add(name);
        return this;
    }

    public AlterTableSettings addChangefeed(Changefeed changefeed) {
        this.addChangefeeds.add(changefeed);
        return this;
    }

    public AlterTableSettings dropChangefeed(String changefeed) {
        this.dropChangefeeds.add(changefeed);
        return this;
    }

    public void forEachAddColumn(BiConsumer<String, Type> fn) {
        this.addColumns.forEach(fn);
    }

    public void forEachDropColumn(Consumer<String> fn) {
        this.dropColumns.forEach(fn);
    }

    public void forEachAddChangefeed(Consumer<Changefeed> fn) {
        this.addChangefeeds.forEach(fn);
    }

    public void forEachDropChangefeed(Consumer<String> fn) {
        this.dropChangefeeds.forEach(fn);
    }

    @Nullable
    public TtlSettings getTtlSettings() {
        return this.ttlSettings;
    }

    @Nullable
    public PartitioningSettings getPartitioningSettings() {
        return this.partitioningSettings;
    }

    public void setTtlSettings(@Nullable TtlSettings ttlSettings) {
        this.ttlSettings = ttlSettings;
    }

    public void setPartitioningSettings(@Nullable PartitioningSettings partitioningSettings) {
        this.partitioningSettings = partitioningSettings;
    }
}

