/*
 * Decompiled with CFR 0.152.
 */
package tech.ydb.table.query;

import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.ParametersAreNonnullByDefault;
import tech.ydb.proto.ValueProtos;
import tech.ydb.table.query.Params;
import tech.ydb.table.values.Type;
import tech.ydb.table.values.Value;
import tech.ydb.table.values.proto.ProtoValue;

@ParametersAreNonnullByDefault
final class ParamsMutableMap
implements Params {
    private final HashMap<String, Value<?>> params;

    ParamsMutableMap() {
        this.params = new HashMap();
    }

    ParamsMutableMap(int expectedSize) {
        this.params = Maps.newHashMapWithExpectedSize(expectedSize);
    }

    ParamsMutableMap(Map<String, Value<?>> params) {
        this.params = new HashMap(params);
    }

    @Override
    public boolean isEmpty() {
        return this.params.isEmpty();
    }

    @Override
    public <T extends Type> Params put(String name, Value<T> value) {
        Value<T> prev = this.params.putIfAbsent(name, value);
        Preconditions.checkArgument(prev == null, "duplicate parameter: %s", (Object)name);
        return this;
    }

    @Override
    public Map<String, ValueProtos.TypedValue> toPb() {
        HashMap<String, ValueProtos.TypedValue> result = Maps.newHashMapWithExpectedSize(this.params.size());
        for (Map.Entry<String, Value<?>> entry : this.params.entrySet()) {
            Value<?> value = entry.getValue();
            String name = entry.getKey();
            ValueProtos.TypedValue valuePb = ProtoValue.toTypedValue(value);
            result.put(name, valuePb);
        }
        return Collections.unmodifiableMap(result);
    }

    @Override
    public Map<String, Value<?>> values() {
        return Collections.unmodifiableMap(this.params);
    }
}

