/*
 * Decompiled with CFR 0.152.
 */
package tech.ydb.table;

import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import tech.ydb.core.Result;
import tech.ydb.core.Status;
import tech.ydb.core.grpc.GrpcReadStream;
import tech.ydb.core.impl.call.ProxyReadStream;
import tech.ydb.table.description.TableDescription;
import tech.ydb.table.query.DataQuery;
import tech.ydb.table.query.DataQueryResult;
import tech.ydb.table.query.ExplainDataQueryResult;
import tech.ydb.table.query.Params;
import tech.ydb.table.query.ReadTablePart;
import tech.ydb.table.result.ResultSetReader;
import tech.ydb.table.settings.AlterTableSettings;
import tech.ydb.table.settings.BeginTxSettings;
import tech.ydb.table.settings.BulkUpsertSettings;
import tech.ydb.table.settings.CommitTxSettings;
import tech.ydb.table.settings.CopyTableSettings;
import tech.ydb.table.settings.CopyTablesSettings;
import tech.ydb.table.settings.CreateTableSettings;
import tech.ydb.table.settings.DescribeTableSettings;
import tech.ydb.table.settings.DropTableSettings;
import tech.ydb.table.settings.ExecuteDataQuerySettings;
import tech.ydb.table.settings.ExecuteScanQuerySettings;
import tech.ydb.table.settings.ExecuteSchemeQuerySettings;
import tech.ydb.table.settings.ExplainDataQuerySettings;
import tech.ydb.table.settings.KeepAliveSessionSettings;
import tech.ydb.table.settings.PrepareDataQuerySettings;
import tech.ydb.table.settings.ReadTableSettings;
import tech.ydb.table.settings.RollbackTxSettings;
import tech.ydb.table.transaction.Transaction;
import tech.ydb.table.transaction.TxControl;
import tech.ydb.table.values.ListValue;

public interface Session
extends AutoCloseable {
    public String getId();

    @Override
    public void close();

    public CompletableFuture<Status> createTable(String var1, TableDescription var2, CreateTableSettings var3);

    public CompletableFuture<Status> dropTable(String var1, DropTableSettings var2);

    public CompletableFuture<Status> alterTable(String var1, AlterTableSettings var2);

    public CompletableFuture<Status> copyTable(String var1, String var2, CopyTableSettings var3);

    public CompletableFuture<Status> copyTables(CopyTablesSettings var1);

    public CompletableFuture<Result<TableDescription>> describeTable(String var1, DescribeTableSettings var2);

    public CompletableFuture<Result<DataQuery>> prepareDataQuery(String var1, PrepareDataQuerySettings var2);

    public CompletableFuture<Result<DataQueryResult>> executeDataQuery(String var1, TxControl<?> var2, Params var3, ExecuteDataQuerySettings var4);

    public CompletableFuture<Status> executeSchemeQuery(String var1, ExecuteSchemeQuerySettings var2);

    public CompletableFuture<Result<ExplainDataQueryResult>> explainDataQuery(String var1, ExplainDataQuerySettings var2);

    public CompletableFuture<Result<Transaction>> beginTransaction(Transaction.Mode var1, BeginTxSettings var2);

    public CompletableFuture<Status> commitTransaction(String var1, CommitTxSettings var2);

    public CompletableFuture<Status> rollbackTransaction(String var1, RollbackTxSettings var2);

    public GrpcReadStream<ReadTablePart> executeReadTable(String var1, ReadTableSettings var2);

    public GrpcReadStream<ResultSetReader> executeScanQuery(String var1, Params var2, ExecuteScanQuerySettings var3);

    @Deprecated
    default public GrpcReadStream<ResultSetReader> readTable(String tablePath, ReadTableSettings settings) {
        return new ProxyReadStream(this.executeReadTable(tablePath, settings), (part, promise, observer) -> observer.onNext(part.getResultSetReader()));
    }

    @Deprecated
    default public CompletableFuture<Status> readTable(String tablePath, ReadTableSettings settings, Consumer<ResultSetReader> fn) {
        return this.executeReadTable(tablePath, settings).start(part -> fn.accept(part.getResultSetReader()));
    }

    @Deprecated
    default public CompletableFuture<Status> executeScanQuery(String query, Params params, ExecuteScanQuerySettings settings, Consumer<ResultSetReader> fn) {
        return this.executeScanQuery(query, params, settings).start(fn::accept);
    }

    public CompletableFuture<Result<State>> keepAlive(KeepAliveSessionSettings var1);

    public CompletableFuture<Status> executeBulkUpsert(String var1, ListValue var2, BulkUpsertSettings var3);

    default public CompletableFuture<Status> createTable(String path, TableDescription tableDescriptions) {
        return this.createTable(path, tableDescriptions, new CreateTableSettings());
    }

    default public CompletableFuture<Status> dropTable(String path) {
        return this.dropTable(path, new DropTableSettings());
    }

    default public CompletableFuture<Status> alterTable(String path) {
        return this.alterTable(path, new AlterTableSettings());
    }

    default public CompletableFuture<Status> copyTable(String src, String dst) {
        return this.copyTable(src, dst, new CopyTableSettings());
    }

    default public CompletableFuture<Result<TableDescription>> describeTable(String path) {
        return this.describeTable(path, new DescribeTableSettings());
    }

    default public CompletableFuture<Result<DataQueryResult>> executeDataQuery(String query, TxControl<?> txControl, Params params) {
        return this.executeDataQuery(query, txControl, params, new ExecuteDataQuerySettings());
    }

    default public CompletableFuture<Result<DataQueryResult>> executeDataQuery(String query, TxControl<?> txControl) {
        return this.executeDataQuery(query, txControl, Params.empty(), new ExecuteDataQuerySettings());
    }

    default public CompletableFuture<Result<DataQuery>> prepareDataQuery(String query) {
        return this.prepareDataQuery(query, new PrepareDataQuerySettings());
    }

    default public CompletableFuture<Status> executeSchemeQuery(String query) {
        return this.executeSchemeQuery(query, new ExecuteSchemeQuerySettings());
    }

    default public CompletableFuture<Result<ExplainDataQueryResult>> explainDataQuery(String query) {
        return this.explainDataQuery(query, new ExplainDataQuerySettings());
    }

    default public CompletableFuture<Result<Transaction>> beginTransaction(Transaction.Mode transactionMode) {
        return this.beginTransaction(transactionMode, new BeginTxSettings());
    }

    default public CompletableFuture<Status> executeBulkUpsert(String tablePath, ListValue rows) {
        return this.executeBulkUpsert(tablePath, rows, new BulkUpsertSettings());
    }

    default public CompletableFuture<Result<State>> keepAlive() {
        return this.keepAlive(new KeepAliveSessionSettings());
    }

    public static enum State {
        UNSPECIFIED,
        READY,
        BUSY;

    }
}

