/*
 * Decompiled with CFR 0.152.
 */
package tech.ydb.scheme.impl;

import java.util.concurrent.CompletableFuture;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.WillClose;
import javax.annotation.WillNotClose;
import tech.ydb.core.Operations;
import tech.ydb.core.Result;
import tech.ydb.core.Status;
import tech.ydb.core.grpc.GrpcRequestSettings;
import tech.ydb.core.grpc.GrpcTransport;
import tech.ydb.proto.scheme.SchemeOperationProtos;
import tech.ydb.proto.scheme.v1.SchemeServiceGrpc;
import tech.ydb.scheme.impl.SchemeRpc;

@ParametersAreNonnullByDefault
public final class GrpcSchemeRpc
implements SchemeRpc {
    private final GrpcTransport transport;
    private final boolean transportOwned;

    private GrpcSchemeRpc(GrpcTransport transport, boolean transportOwned) {
        this.transport = transport;
        this.transportOwned = transportOwned;
    }

    public static GrpcSchemeRpc useTransport(@WillNotClose GrpcTransport transport) {
        return new GrpcSchemeRpc(transport, false);
    }

    public static GrpcSchemeRpc ownTransport(@WillClose GrpcTransport transport) {
        return new GrpcSchemeRpc(transport, true);
    }

    @Override
    public CompletableFuture<Status> makeDirectory(SchemeOperationProtos.MakeDirectoryRequest request, GrpcRequestSettings settings) {
        return this.transport.unaryCall(SchemeServiceGrpc.getMakeDirectoryMethod(), settings, request).thenApply(Operations.statusUnwrapper(SchemeOperationProtos.MakeDirectoryResponse::getOperation));
    }

    @Override
    public CompletableFuture<Status> removeDirectory(SchemeOperationProtos.RemoveDirectoryRequest request, GrpcRequestSettings settings) {
        return this.transport.unaryCall(SchemeServiceGrpc.getRemoveDirectoryMethod(), settings, request).thenApply(Operations.statusUnwrapper(SchemeOperationProtos.RemoveDirectoryResponse::getOperation));
    }

    @Override
    public CompletableFuture<Result<SchemeOperationProtos.ListDirectoryResult>> describeDirectory(SchemeOperationProtos.ListDirectoryRequest request, GrpcRequestSettings settings) {
        return this.transport.unaryCall(SchemeServiceGrpc.getListDirectoryMethod(), settings, request).thenApply(Operations.resultUnwrapper(SchemeOperationProtos.ListDirectoryResponse::getOperation, SchemeOperationProtos.ListDirectoryResult.class));
    }

    @Override
    public CompletableFuture<Result<SchemeOperationProtos.DescribePathResult>> describePath(SchemeOperationProtos.DescribePathRequest request, GrpcRequestSettings settings) {
        return this.transport.unaryCall(SchemeServiceGrpc.getDescribePathMethod(), settings, request).thenApply(Operations.resultUnwrapper(SchemeOperationProtos.DescribePathResponse::getOperation, SchemeOperationProtos.DescribePathResult.class));
    }

    @Override
    public String getDatabase() {
        return this.transport.getDatabase();
    }

    @Override
    public void close() {
        if (this.transportOwned) {
            this.transport.close();
        }
    }
}

