/*
 * Decompiled with CFR 0.152.
 */
package tech.ydb.jdbc.settings;

import java.sql.DriverPropertyInfo;
import java.util.ArrayList;
import java.util.Objects;
import tech.ydb.jdbc.settings.ParsedProperty;
import tech.ydb.jdbc.settings.YdbClientProperties;
import tech.ydb.jdbc.settings.YdbConnectionProperties;
import tech.ydb.jdbc.settings.YdbOperationProperties;

public class YdbProperties {
    private final YdbConnectionProperties connectionProperties;
    private final YdbClientProperties clientProperties;
    private final YdbOperationProperties operationProperties;

    public YdbProperties(YdbConnectionProperties connectionProperties, YdbClientProperties clientProperties, YdbOperationProperties operationProperties) {
        this.connectionProperties = Objects.requireNonNull(connectionProperties);
        this.clientProperties = Objects.requireNonNull(clientProperties);
        this.operationProperties = Objects.requireNonNull(operationProperties);
    }

    public YdbConnectionProperties getConnectionProperties() {
        return this.connectionProperties;
    }

    public YdbClientProperties getClientProperties() {
        return this.clientProperties;
    }

    public YdbOperationProperties getOperationProperties() {
        return this.operationProperties;
    }

    public DriverPropertyInfo[] toDriverProperties() {
        ArrayList properties = new ArrayList();
        this.connectionProperties.getParams().forEach((property, value) -> properties.add(property.toDriverPropertyInfoFrom((ParsedProperty)value)));
        this.clientProperties.getParams().forEach((property, value) -> properties.add(property.toDriverPropertyInfoFrom((ParsedProperty)value)));
        this.operationProperties.getParams().forEach((property, value) -> properties.add(property.toDriverPropertyInfoFrom((ParsedProperty)value)));
        return properties.toArray(new DriverPropertyInfo[0]);
    }
}

