/*
 * Decompiled with CFR 0.152.
 */
package tech.ydb.jdbc.settings;

import java.time.Duration;
import java.util.Map;
import java.util.Objects;
import tech.ydb.jdbc.query.QueryType;
import tech.ydb.jdbc.settings.FakeTxMode;
import tech.ydb.jdbc.settings.ParsedProperty;
import tech.ydb.jdbc.settings.YdbOperationProperty;

public class YdbOperationProperties {
    public static final int MAX_ROWS = 1000;
    private final Map<YdbOperationProperty<?>, ParsedProperty> params;
    private final Duration joinDuration;
    private final Duration queryTimeout;
    private final Duration scanQueryTimeout;
    private final boolean failOnTruncatedResult;
    private final Duration sessionTimeout;
    private final Duration deadlineTimeout;
    private final boolean autoCommit;
    private final int transactionLevel;
    private final int maxRows;
    private final boolean cacheConnectionsInDriver;
    private final int preparedStatementCacheSize;
    private final FakeTxMode scanQueryTxMode;
    private final FakeTxMode schemeQueryTxMode;
    private final QueryType forcedQueryType;

    public YdbOperationProperties(Map<YdbOperationProperty<?>, ParsedProperty> params) {
        this.params = Objects.requireNonNull(params);
        this.joinDuration = (Duration)params.get(YdbOperationProperty.JOIN_DURATION).getParsedValue();
        this.queryTimeout = (Duration)params.get(YdbOperationProperty.QUERY_TIMEOUT).getParsedValue();
        this.scanQueryTimeout = (Duration)params.get(YdbOperationProperty.SCAN_QUERY_TIMEOUT).getParsedValue();
        this.failOnTruncatedResult = (Boolean)params.get(YdbOperationProperty.FAIL_ON_TRUNCATED_RESULT).getParsedValue();
        this.sessionTimeout = (Duration)params.get(YdbOperationProperty.SESSION_TIMEOUT).getParsedValue();
        this.deadlineTimeout = (Duration)params.get(YdbOperationProperty.DEADLINE_TIMEOUT).getParsedValue();
        this.autoCommit = (Boolean)params.get(YdbOperationProperty.AUTOCOMMIT).getParsedValue();
        this.transactionLevel = (Integer)params.get(YdbOperationProperty.TRANSACTION_LEVEL).getParsedValue();
        this.maxRows = 1000;
        this.cacheConnectionsInDriver = (Boolean)params.get(YdbOperationProperty.CACHE_CONNECTIONS_IN_DRIVER).getParsedValue();
        this.preparedStatementCacheSize = Math.max(0, (Integer)params.get(YdbOperationProperty.PREPARED_STATEMENT_CACHE_SIZE).getParsedValue());
        this.scanQueryTxMode = (FakeTxMode)((Object)params.get(YdbOperationProperty.SCAN_QUERY_TX_MODE).getParsedValue());
        this.schemeQueryTxMode = (FakeTxMode)((Object)params.get(YdbOperationProperty.SCHEME_QUERY_TX_MODE).getParsedValue());
        ParsedProperty forcedType = params.get(YdbOperationProperty.FORCE_QUERY_MODE);
        this.forcedQueryType = forcedType != null ? (QueryType)((Object)forcedType.getParsedValue()) : null;
    }

    public Map<YdbOperationProperty<?>, ParsedProperty> getParams() {
        return this.params;
    }

    public Duration getJoinDuration() {
        return this.joinDuration;
    }

    public Duration getQueryTimeout() {
        return this.queryTimeout;
    }

    public Duration getScanQueryTimeout() {
        return this.scanQueryTimeout;
    }

    public boolean isFailOnTruncatedResult() {
        return this.failOnTruncatedResult;
    }

    public FakeTxMode getScanQueryTxMode() {
        return this.scanQueryTxMode;
    }

    public FakeTxMode getSchemeQueryTxMode() {
        return this.schemeQueryTxMode;
    }

    public QueryType getForcedQueryType() {
        return this.forcedQueryType;
    }

    public Duration getSessionTimeout() {
        return this.sessionTimeout;
    }

    public Duration getDeadlineTimeout() {
        return this.deadlineTimeout;
    }

    public boolean isAutoCommit() {
        return this.autoCommit;
    }

    public int getTransactionLevel() {
        return this.transactionLevel;
    }

    public int getMaxRows() {
        return this.maxRows;
    }

    public boolean isCacheConnectionsInDriver() {
        return this.cacheConnectionsInDriver;
    }

    public int getPreparedStatementCacheSize() {
        return this.preparedStatementCacheSize;
    }
}

