/*
 * Decompiled with CFR 0.152.
 */
package tech.ydb.jdbc.settings;

import java.sql.SQLException;
import java.time.Duration;
import java.time.format.DateTimeParseException;
import java.util.Locale;
import tech.ydb.jdbc.settings.YdbLookup;

interface PropertyConverter<T> {
    public T convert(String var1) throws SQLException;

    public static PropertyConverter<String> stringValue() {
        return value -> value;
    }

    public static <E extends Enum<E>> PropertyConverter<E> enumValue(Class<E> clazz) {
        return value -> {
            for (Enum v : (Enum[])clazz.getEnumConstants()) {
                if (!value.equalsIgnoreCase(v.name())) continue;
                return v;
            }
            return null;
        };
    }

    public static PropertyConverter<Duration> durationValue() {
        return value -> {
            String targetValue = "PT" + value.replace(" ", "").toUpperCase(Locale.ROOT);
            try {
                return Duration.parse(targetValue);
            }
            catch (DateTimeParseException e) {
                throw new RuntimeException("Unable to parse value [" + value + "] -> [" + targetValue + "] as Duration: " + e.getMessage(), e);
            }
        };
    }

    public static PropertyConverter<Integer> integerValue() {
        return value -> {
            try {
                return Integer.valueOf(value);
            }
            catch (NumberFormatException e) {
                throw new RuntimeException("Unable to parse value [" + value + "] as Integer: " + e.getMessage(), e);
            }
        };
    }

    public static PropertyConverter<Boolean> booleanValue() {
        return Boolean::valueOf;
    }

    public static PropertyConverter<String> stringFileReference() {
        return YdbLookup::stringFileReference;
    }

    public static PropertyConverter<byte[]> byteFileReference() {
        return YdbLookup::byteFileReference;
    }
}

