/*
 * Decompiled with CFR 0.152.
 */
package tech.ydb.jdbc.settings;

import java.sql.DriverPropertyInfo;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiConsumer;
import javax.annotation.Nullable;
import tech.ydb.jdbc.settings.PropertyConverter;
import tech.ydb.jdbc.settings.ToDriverPropertyInfo;

public abstract class AbstractYdbProperty<T, B>
implements ToDriverPropertyInfo {
    private final String name;
    private final String description;
    @Nullable
    private final String defaultValue;
    private final Class<T> type;
    private final PropertyConverter<T> converter;
    private final BiConsumer<B, T> setter;

    protected AbstractYdbProperty(String name, String description, @Nullable String defaultValue, Class<T> type, PropertyConverter<T> converter, BiConsumer<B, T> setter) {
        this.name = Objects.requireNonNull(name);
        this.description = Objects.requireNonNull(description);
        this.defaultValue = defaultValue;
        this.type = Objects.requireNonNull(type);
        this.converter = Objects.requireNonNull(converter);
        this.setter = Objects.requireNonNull(setter);
    }

    public String getName() {
        return this.name;
    }

    @Nullable
    public String getDefaultValue() {
        return this.defaultValue;
    }

    public PropertyConverter<T> getConverter() {
        return this.converter;
    }

    public Class<T> getType() {
        return this.type;
    }

    public BiConsumer<B, T> getSetter() {
        return this.setter;
    }

    @Override
    public DriverPropertyInfo toDriverPropertyInfo(@Nullable String value) {
        DriverPropertyInfo info = new DriverPropertyInfo(this.name, value != null ? value : (this.defaultValue != null ? this.defaultValue : ""));
        info.description = this.description;
        info.required = false;
        return info;
    }

    static class PropertiesCollector<T extends AbstractYdbProperty<?, ?>> {
        private final Map<String, T> properties = new LinkedHashMap<String, T>();

        PropertiesCollector() {
        }

        protected void register(T property) {
            if (this.properties.put(((AbstractYdbProperty)property).getName(), property) != null) {
                throw new IllegalStateException("Internal error. Unable to register property with name " + ((AbstractYdbProperty)property).getName() + " twice");
            }
        }

        protected Collection<T> properties() {
            return Collections.unmodifiableCollection(this.properties.values());
        }
    }
}

