/*
 * Decompiled with CFR 0.152.
 */
package tech.ydb.jdbc.query;

import com.google.common.annotations.VisibleForTesting;
import java.util.Map;
import tech.ydb.jdbc.query.QueryType;
import tech.ydb.jdbc.settings.ParsedProperty;
import tech.ydb.jdbc.settings.YdbOperationProperties;
import tech.ydb.jdbc.settings.YdbOperationProperty;

public class YdbQueryOptions {
    private final boolean isDetectQueryType;
    private final boolean isDetectJdbcParameters;
    private final boolean isDeclareJdbcParameters;
    private final boolean isPrepareDataQueries;
    private final boolean isDetectBatchQueries;
    private final QueryType forcedType;

    @VisibleForTesting
    YdbQueryOptions(boolean detectQueryType, boolean detectJbdcParams, boolean declareJdbcParams, boolean prepareDataQuery, boolean detectBatchQuery, QueryType forcedType) {
        this.isDetectQueryType = detectQueryType;
        this.isDetectJdbcParameters = detectJbdcParams;
        this.isDeclareJdbcParameters = declareJdbcParams;
        this.isPrepareDataQueries = prepareDataQuery;
        this.isDetectBatchQueries = detectBatchQuery;
        this.forcedType = forcedType;
    }

    public boolean isDetectQueryType() {
        return this.isDetectQueryType;
    }

    public boolean isDetectJdbcParameters() {
        return this.isDetectJdbcParameters;
    }

    public boolean isDeclareJdbcParameters() {
        return this.isDeclareJdbcParameters;
    }

    public boolean iPrepareDataQueries() {
        return this.isPrepareDataQueries;
    }

    public boolean isDetectBatchQueries() {
        return this.isDetectBatchQueries;
    }

    public QueryType getForcedQueryType() {
        return this.forcedType;
    }

    public static YdbQueryOptions createFrom(YdbOperationProperties props) {
        boolean v;
        boolean declareJdbcParams = true;
        boolean detectJbdcParams = true;
        boolean detectBatchQuery = true;
        boolean prepareDataQuery = true;
        boolean detectQueryType = true;
        Map<YdbOperationProperty<?>, ParsedProperty> params = props.getParams();
        if (params.containsKey(YdbOperationProperty.DISABLE_AUTO_PREPARED_BATCHES)) {
            v = (Boolean)params.get(YdbOperationProperty.DISABLE_AUTO_PREPARED_BATCHES).getParsedValue();
            boolean bl = detectBatchQuery = !v;
        }
        if (params.containsKey(YdbOperationProperty.DISABLE_PREPARE_DATAQUERY)) {
            v = (Boolean)params.get(YdbOperationProperty.DISABLE_PREPARE_DATAQUERY).getParsedValue();
            prepareDataQuery = !v;
            boolean bl = detectBatchQuery = detectBatchQuery && prepareDataQuery;
        }
        if (params.containsKey(YdbOperationProperty.DISABLE_JDBC_PARAMETERS_DECLARE)) {
            v = (Boolean)params.get(YdbOperationProperty.DISABLE_JDBC_PARAMETERS_DECLARE).getParsedValue();
            boolean bl = declareJdbcParams = !v;
        }
        if (params.containsKey(YdbOperationProperty.DISABLE_JDBC_PARAMETERS)) {
            v = (Boolean)params.get(YdbOperationProperty.DISABLE_JDBC_PARAMETERS).getParsedValue();
            detectJbdcParams = !v;
            boolean bl = declareJdbcParams = declareJdbcParams && detectJbdcParams;
        }
        if (params.containsKey(YdbOperationProperty.DISABLE_DETECT_SQL_OPERATIONS)) {
            v = (Boolean)params.get(YdbOperationProperty.DISABLE_DETECT_SQL_OPERATIONS).getParsedValue();
            detectQueryType = !v;
            detectJbdcParams = detectJbdcParams && detectQueryType;
            declareJdbcParams = declareJdbcParams && detectJbdcParams;
        }
        QueryType forcedQueryType = props.getForcedQueryType();
        return new YdbQueryOptions(detectQueryType, detectJbdcParams, declareJdbcParams, prepareDataQuery, detectBatchQuery, forcedQueryType);
    }
}

