/*
 * Decompiled with CFR 0.152.
 */
package tech.ydb.jdbc.impl;

import com.google.common.base.Suppliers;
import java.sql.Array;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.NClob;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Savepoint;
import java.sql.Struct;
import java.time.Duration;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.Executor;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.function.Supplier;
import java.util.logging.Level;
import java.util.logging.Logger;
import tech.ydb.jdbc.YdbConnection;
import tech.ydb.jdbc.YdbDatabaseMetaData;
import tech.ydb.jdbc.YdbPrepareMode;
import tech.ydb.jdbc.YdbPreparedStatement;
import tech.ydb.jdbc.YdbStatement;
import tech.ydb.jdbc.YdbTypes;
import tech.ydb.jdbc.context.YdbContext;
import tech.ydb.jdbc.context.YdbExecutor;
import tech.ydb.jdbc.context.YdbTxState;
import tech.ydb.jdbc.impl.YdbDatabaseMetaDataImpl;
import tech.ydb.jdbc.impl.YdbPreparedStatementImpl;
import tech.ydb.jdbc.impl.YdbStatementImpl;
import tech.ydb.jdbc.impl.YdbTypesImpl;
import tech.ydb.jdbc.query.JdbcParams;
import tech.ydb.jdbc.query.QueryType;
import tech.ydb.jdbc.query.YdbQuery;
import tech.ydb.jdbc.settings.FakeTxMode;
import tech.ydb.jdbc.settings.YdbOperationProperties;
import tech.ydb.table.Session;
import tech.ydb.table.query.DataQueryResult;
import tech.ydb.table.query.ExplainDataQueryResult;
import tech.ydb.table.query.Params;
import tech.ydb.table.result.ResultSetReader;
import tech.ydb.table.result.impl.ProtoValueReaders;
import tech.ydb.table.settings.CommitTxSettings;
import tech.ydb.table.settings.ExecuteDataQuerySettings;
import tech.ydb.table.settings.ExecuteScanQuerySettings;
import tech.ydb.table.settings.ExecuteSchemeQuerySettings;
import tech.ydb.table.settings.ExplainDataQuerySettings;
import tech.ydb.table.settings.KeepAliveSessionSettings;
import tech.ydb.table.settings.RollbackTxSettings;

public class YdbConnectionImpl
implements YdbConnection {
    private static final Logger LOGGER = Logger.getLogger(YdbConnectionImpl.class.getName());
    private final YdbContext ctx;
    private final YdbExecutor executor;
    private final Supplier<YdbDatabaseMetaData> metaDataSupplier;
    private final FakeTxMode scanQueryTxMode;
    private final FakeTxMode schemeQueryTxMode;
    private volatile YdbTxState state;

    public YdbConnectionImpl(YdbContext context) throws SQLException {
        this.ctx = context;
        this.metaDataSupplier = Suppliers.memoize(() -> new YdbDatabaseMetaDataImpl(this))::get;
        this.executor = new YdbExecutor(LOGGER);
        YdbOperationProperties props = this.ctx.getOperationProperties();
        this.scanQueryTxMode = props.getScanQueryTxMode();
        this.schemeQueryTxMode = props.getSchemeQueryTxMode();
        this.state = YdbTxState.create(props.getTransactionLevel(), props.isAutoCommit());
        this.ctx.register();
    }

    @Override
    public YdbStatement createStatement() throws SQLException {
        return this.createStatement(1004, 1007, 1);
    }

    @Override
    public YdbPreparedStatement prepareStatement(String sql) throws SQLException {
        return this.prepareStatement(sql, 1004, 1007, 1);
    }

    @Override
    public String nativeSQL(String sql) {
        try {
            return this.ctx.parseYdbQuery(sql).getYqlQuery(null);
        }
        catch (SQLException ex) {
            return ex.getMessage();
        }
    }

    private void updateState(YdbTxState newState) {
        if (this.state == newState) {
            return;
        }
        LOGGER.log(Level.FINE, "update tx state: {0} -> {1}", new Object[]{this.state, newState});
        this.state = newState;
    }

    @Override
    public void setAutoCommit(boolean autoCommit) throws SQLException {
        this.ensureOpened();
        if (autoCommit == this.state.isAutoCommit()) {
            return;
        }
        LOGGER.log(Level.FINE, "Set auto-commit: {0}", autoCommit);
        if (autoCommit) {
            this.commit();
        }
        this.updateState(this.state.withAutoCommit(autoCommit));
    }

    @Override
    public boolean getAutoCommit() throws SQLException {
        this.ensureOpened();
        return this.state.isAutoCommit();
    }

    @Override
    public void commit() throws SQLException {
        this.ensureOpened();
        if (!this.state.isInsideTransaction()) {
            return;
        }
        Session session = this.state.getSession(this.ctx, this.executor);
        CommitTxSettings settings = this.ctx.withDefaultTimeout(new CommitTxSettings());
        try {
            this.executor.clearWarnings();
            this.executor.execute("Commit TxId: " + this.state.txID(), () -> session.commitTransaction(this.state.txID(), settings));
        }
        finally {
            this.updateState(this.state.withCommit(session));
        }
    }

    @Override
    public void rollback() throws SQLException {
        this.ensureOpened();
        if (!this.state.isInsideTransaction()) {
            return;
        }
        Session session = this.state.getSession(this.ctx, this.executor);
        RollbackTxSettings settings = this.ctx.withDefaultTimeout(new RollbackTxSettings());
        try {
            this.executor.clearWarnings();
            this.executor.execute("Rollback TxId: " + this.state.txID(), () -> session.rollbackTransaction(this.state.txID(), settings));
        }
        finally {
            this.updateState(this.state.withRollback(session));
        }
    }

    @Override
    public void close() throws SQLException {
        if (this.isClosed()) {
            return;
        }
        this.commit();
        this.executor.clearWarnings();
        this.state = null;
        this.ctx.deregister();
    }

    @Override
    public boolean isClosed() {
        return this.state == null;
    }

    @Override
    public YdbDatabaseMetaData getMetaData() {
        return this.metaDataSupplier.get();
    }

    @Override
    public void setReadOnly(boolean readOnly) throws SQLException {
        this.ensureOpened();
        this.state = this.state.withReadOnly(readOnly);
    }

    @Override
    public boolean isReadOnly() throws SQLException {
        return this.state.isReadOnly();
    }

    @Override
    public void setCatalog(String catalog) {
    }

    @Override
    public String getCatalog() {
        return null;
    }

    @Override
    public void setTransactionIsolation(int level) throws SQLException {
        this.ensureOpened();
        if (this.state.transactionLevel() == level) {
            return;
        }
        LOGGER.log(Level.FINE, "Set transaction isolation level: {0}", level);
        this.updateState(this.state.withTransactionLevel(level));
    }

    @Override
    public int getTransactionIsolation() throws SQLException {
        this.ensureOpened();
        return this.state.transactionLevel();
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        this.ensureOpened();
        return this.executor.toSQLWarnings();
    }

    @Override
    public void clearWarnings() throws SQLException {
        this.ensureOpened();
        this.executor.clearWarnings();
    }

    @Override
    public void executeSchemeQuery(YdbQuery query, YdbExecutor executor) throws SQLException {
        this.ensureOpened();
        if (this.state.isInsideTransaction()) {
            switch (this.schemeQueryTxMode) {
                case FAKE_TX: {
                    break;
                }
                case SHADOW_COMMIT: {
                    this.commit();
                    break;
                }
                default: {
                    throw new SQLException("Scheme query cannot be executed inside active transaction. This behavior may be changed by property schemeQueryTxMode");
                }
            }
        }
        ExecuteSchemeQuerySettings settings = this.ctx.withDefaultTimeout(new ExecuteSchemeQuerySettings());
        String yql = query.getYqlQuery(null);
        try (Session session = executor.createSession(this.ctx);){
            executor.execute((Object)((Object)QueryType.SCHEME_QUERY) + " >>\n" + yql, () -> session.executeSchemeQuery(yql, settings));
        }
    }

    @Override
    public DataQueryResult executeDataQuery(YdbQuery query, YdbExecutor executor, ExecuteDataQuerySettings settings, Params params) throws SQLException {
        this.ensureOpened();
        String yql = query.getYqlQuery(params);
        Session session = this.state.getSession(this.ctx, executor);
        try {
            DataQueryResult result = (DataQueryResult)executor.call((Object)((Object)QueryType.DATA_QUERY) + " >>\n" + yql, () -> session.executeDataQuery(yql, this.state.txControl(), params, settings));
            this.updateState(this.state.withDataQuery(session, result.getTxId()));
            return result;
        }
        catch (RuntimeException | SQLException ex) {
            this.updateState(this.state.withRollback(session));
            throw ex;
        }
    }

    @Override
    public ResultSetReader executeScanQuery(YdbQuery query, YdbExecutor executor, Params params) throws SQLException {
        this.ensureOpened();
        if (this.state.isInsideTransaction()) {
            switch (this.scanQueryTxMode) {
                case FAKE_TX: {
                    break;
                }
                case SHADOW_COMMIT: {
                    this.commit();
                    break;
                }
                default: {
                    throw new SQLException("Scan query cannot be executed inside active transaction. This behavior may be changed by property scanQueryTxMode");
                }
            }
        }
        String yql = query.getYqlQuery(params);
        LinkedBlockingQueue<ResultSetReader> resultSets = new LinkedBlockingQueue<ResultSetReader>();
        Duration scanQueryTimeout = this.ctx.getOperationProperties().getScanQueryTimeout();
        ExecuteScanQuerySettings settings = ((ExecuteScanQuerySettings.Builder)ExecuteScanQuerySettings.newBuilder().withRequestTimeout(scanQueryTimeout)).build();
        try (Session session = executor.createSession(this.ctx);){
            executor.execute((Object)((Object)QueryType.SCAN_QUERY) + " >>\n" + yql, () -> session.executeScanQuery(yql, params, settings).start(resultSets::add));
        }
        return ProtoValueReaders.forResultSets(resultSets);
    }

    @Override
    public ExplainDataQueryResult executeExplainQuery(YdbQuery query, YdbExecutor executor) throws SQLException {
        this.ensureOpened();
        String yql = query.getYqlQuery(null);
        ExplainDataQuerySettings settings = this.ctx.withDefaultTimeout(new ExplainDataQuerySettings());
        try (Session session = executor.createSession(this.ctx);){
            String msg = (Object)((Object)QueryType.EXPLAIN_QUERY) + " >>\n" + yql;
            ExplainDataQueryResult explainDataQueryResult = (ExplainDataQueryResult)executor.call(msg, () -> session.explainDataQuery(yql, settings));
            return explainDataQueryResult;
        }
    }

    @Override
    public YdbStatement createStatement(int resultSetType, int resultSetConcurrency) throws SQLException {
        return this.createStatement(resultSetType, resultSetConcurrency, 1);
    }

    @Override
    public YdbPreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        return this.prepareStatement(sql, resultSetType, resultSetConcurrency, 1);
    }

    @Override
    public Map<String, Class<?>> getTypeMap() {
        return new HashMap();
    }

    @Override
    public void setTypeMap(Map<String, Class<?>> map) {
    }

    @Override
    public void setHoldability(int holdability) throws SQLException {
        this.ensureOpened();
        if (holdability != 1) {
            throw new SQLFeatureNotSupportedException("resultSetHoldability must be ResultSet.HOLD_CURSORS_OVER_COMMIT");
        }
    }

    @Override
    public int getHoldability() throws SQLException {
        this.ensureOpened();
        return 1;
    }

    @Override
    public YdbStatement createStatement(int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        this.ensureOpened();
        this.checkStatementParams(resultSetType, resultSetConcurrency, resultSetHoldability);
        return new YdbStatementImpl(this, resultSetType);
    }

    @Override
    public YdbPreparedStatement prepareStatement(String origSql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        this.checkStatementParams(resultSetType, resultSetConcurrency, resultSetHoldability);
        return this.prepareStatement(origSql, resultSetType, YdbPrepareMode.AUTO);
    }

    @Override
    public YdbPreparedStatement prepareStatement(String sql, YdbPrepareMode mode) throws SQLException {
        return this.prepareStatement(sql, 1004, mode);
    }

    @Override
    public YdbPreparedStatement prepareStatement(String sql, int autoGeneratedKeys) throws SQLException {
        if (autoGeneratedKeys != 2) {
            throw new SQLFeatureNotSupportedException("Auto-generated keys are not supported");
        }
        return this.prepareStatement(sql, 1003, 1007, 1);
    }

    private YdbPreparedStatement prepareStatement(String sql, int resultSetType, YdbPrepareMode mode) throws SQLException {
        this.ensureOpened();
        this.executor.clearWarnings();
        YdbQuery query = this.ctx.findOrParseYdbQuery(sql);
        if (query.type() != QueryType.DATA_QUERY && query.type() != QueryType.SCAN_QUERY) {
            throw new SQLException("Query type in prepared statement not supported: " + (Object)((Object)query.type()));
        }
        JdbcParams params = this.ctx.findOrCreateJdbcParams(query, mode);
        return new YdbPreparedStatementImpl(this, query, params, resultSetType);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isValid(int timeout) throws SQLException {
        this.ensureOpened();
        Session session = this.state.getSession(this.ctx, this.executor);
        try {
            KeepAliveSessionSettings settings = (KeepAliveSessionSettings)new KeepAliveSessionSettings().setTimeout(Duration.ofSeconds(timeout));
            Session.State keepAlive = (Session.State)((Object)this.executor.call("Keep alive: " + this.state.txID(), () -> session.keepAlive(settings)));
            boolean bl = keepAlive == Session.State.READY;
            return bl;
        }
        finally {
            this.updateState(this.state.withKeepAlive(session));
        }
    }

    @Override
    public void setClientInfo(String name, String value) {
    }

    @Override
    public void setClientInfo(Properties properties) {
    }

    @Override
    public String getClientInfo(String name) {
        return null;
    }

    @Override
    public Properties getClientInfo() {
        return new Properties();
    }

    @Override
    public void setSchema(String schema) {
    }

    @Override
    public String getSchema() {
        return null;
    }

    @Override
    public int getNetworkTimeout() throws SQLException {
        this.ensureOpened();
        return (int)this.ctx.getOperationProperties().getDeadlineTimeout().toMillis();
    }

    @Override
    public YdbTypes getYdbTypes() {
        return YdbTypesImpl.getInstance();
    }

    @Override
    public String getYdbTxId() {
        return this.state.txID();
    }

    @Override
    public YdbContext getCtx() {
        return this.ctx;
    }

    private void ensureOpened() throws SQLException {
        if (this.state == null) {
            throw new SQLException("Connection is closed");
        }
    }

    private void checkStatementParams(int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        if (resultSetType != 1003 && resultSetType != 1004) {
            throw new SQLFeatureNotSupportedException("resultSetType must be ResultSet.TYPE_FORWARD_ONLY or ResultSet.TYPE_SCROLL_INSENSITIVE");
        }
        if (resultSetConcurrency != 1007) {
            throw new SQLFeatureNotSupportedException("resultSetConcurrency must be ResultSet.CONCUR_READ_ONLY");
        }
        if (resultSetHoldability != 1) {
            throw new SQLFeatureNotSupportedException("resultSetHoldability must be ResultSet.HOLD_CURSORS_OVER_COMMIT");
        }
    }

    @Override
    public CallableStatement prepareCall(String sql) throws SQLException {
        throw new SQLFeatureNotSupportedException("Prepared calls are not supported");
    }

    @Override
    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        throw new SQLFeatureNotSupportedException("Prepared calls are not supported");
    }

    @Override
    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        throw new SQLFeatureNotSupportedException("Prepared calls are not supported");
    }

    @Override
    public YdbPreparedStatement prepareStatement(String sql, int[] columnIndexes) throws SQLException {
        throw new SQLFeatureNotSupportedException("Auto-generated keys are not supported");
    }

    @Override
    public YdbPreparedStatement prepareStatement(String sql, String[] columnNames) throws SQLException {
        throw new SQLFeatureNotSupportedException("Auto-generated keys are not supported");
    }

    @Override
    public Clob createClob() throws SQLException {
        throw new SQLFeatureNotSupportedException("Clobs are not supported");
    }

    @Override
    public Blob createBlob() throws SQLException {
        throw new SQLFeatureNotSupportedException("Blobs are not supported");
    }

    @Override
    public NClob createNClob() throws SQLException {
        throw new SQLFeatureNotSupportedException("NClobs are not supported");
    }

    @Override
    public SQLXML createSQLXML() throws SQLException {
        throw new SQLFeatureNotSupportedException("SQLXMLs are not supported");
    }

    @Override
    public Array createArrayOf(String typeName, Object[] elements) throws SQLException {
        throw new SQLFeatureNotSupportedException("Arrays are not supported");
    }

    @Override
    public Struct createStruct(String typeName, Object[] attributes) throws SQLException {
        throw new SQLFeatureNotSupportedException("Structs are not supported");
    }

    @Override
    public Savepoint setSavepoint() throws SQLException {
        throw new SQLFeatureNotSupportedException("Savepoints are not supported");
    }

    @Override
    public Savepoint setSavepoint(String name) throws SQLException {
        throw new SQLFeatureNotSupportedException("Savepoints are not supported");
    }

    @Override
    public void rollback(Savepoint savepoint) throws SQLException {
        throw new SQLFeatureNotSupportedException("Savepoints are not supported");
    }

    @Override
    public void releaseSavepoint(Savepoint savepoint) throws SQLException {
        throw new SQLFeatureNotSupportedException("Savepoints are not supported");
    }

    @Override
    public void abort(Executor executor) throws SQLException {
        throw new SQLFeatureNotSupportedException("Abort operation is not supported yet");
    }

    @Override
    public void setNetworkTimeout(Executor executor, int milliseconds) throws SQLException {
        throw new SQLFeatureNotSupportedException("Set network timeout is not supported yet");
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        if (iface.isAssignableFrom(this.getClass())) {
            return iface.cast(this);
        }
        throw new SQLException("Cannot unwrap to " + iface);
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) {
        return iface.isAssignableFrom(this.getClass());
    }
}

