/*
 * Decompiled with CFR 0.152.
 */
package tech.ydb.jdbc.context;

import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import tech.ydb.jdbc.context.YdbContext;
import tech.ydb.jdbc.context.YdbExecutor;
import tech.ydb.table.Session;
import tech.ydb.table.transaction.TxControl;

public class YdbTxState {
    private final TxControl<?> txControl;
    protected final int transactionLevel;

    protected YdbTxState(TxControl<?> tx, int level) {
        this.txControl = tx;
        this.transactionLevel = level;
    }

    public String toString() {
        return "NoTx" + this.transactionLevel;
    }

    public String txID() {
        return null;
    }

    public TxControl<?> txControl() {
        return this.txControl;
    }

    public boolean isAutoCommit() {
        return this.txControl.isCommitTx();
    }

    public boolean isReadOnly() {
        return this.transactionLevel != 8;
    }

    public boolean isInsideTransaction() {
        return false;
    }

    public int transactionLevel() throws SQLException {
        return this.transactionLevel;
    }

    public YdbTxState withAutoCommit(boolean newAutoCommit) throws SQLException {
        if (newAutoCommit == this.isAutoCommit()) {
            return this;
        }
        return YdbTxState.create(this.transactionLevel(), newAutoCommit);
    }

    public YdbTxState withReadOnly(boolean readOnly) throws SQLException {
        if (readOnly == this.isReadOnly()) {
            return this;
        }
        if (readOnly) {
            return YdbTxState.create(4, this.isAutoCommit());
        }
        return YdbTxState.create(8, this.isAutoCommit());
    }

    public YdbTxState withTransactionLevel(int newTransactionLevel) throws SQLException {
        if (newTransactionLevel == this.transactionLevel()) {
            return this;
        }
        return YdbTxState.create(newTransactionLevel, this.isAutoCommit());
    }

    public YdbTxState withCommit(Session session) {
        session.close();
        return this;
    }

    public YdbTxState withRollback(Session session) {
        session.close();
        return this;
    }

    public YdbTxState withKeepAlive(Session session) {
        session.close();
        return this;
    }

    public YdbTxState withDataQuery(Session session, String txID) {
        if (txID != null && !txID.isEmpty()) {
            return new TransactionInProgress(txID, session, this.isAutoCommit());
        }
        session.close();
        return this;
    }

    public Session getSession(YdbContext ctx, YdbExecutor executor) throws SQLException {
        return executor.createSession(ctx);
    }

    public static YdbTxState create(int level, boolean autoCommit) throws SQLException {
        return YdbTxState.create(null, null, level, autoCommit);
    }

    private static YdbTxState create(Session session, String txId, int level, boolean autoCommit) throws SQLException {
        switch (level) {
            case 8: {
                if (txId != null) {
                    return new TransactionInProgress(txId, session, autoCommit);
                }
                if (autoCommit) {
                    return new YdbTxState(TxControl.serializableRw(), level);
                }
                return new EmptyTransaction();
            }
            case 4: {
                return new YdbTxState(TxControl.onlineRo(), level);
            }
            case 3: {
                return new YdbTxState(TxControl.staleRo(), level);
            }
            case 2: {
                return new YdbTxState(TxControl.onlineRo().setAllowInconsistentReads(true), level);
            }
        }
        throw new SQLException("Unsupported transaction level: " + level);
    }

    private static class TransactionInProgress
    extends YdbTxState {
        private final String id;
        private final Session session;

        TransactionInProgress(String id, Session session, boolean autoCommit) {
            super(TxControl.id(id).setCommitTx(autoCommit), 8);
            this.id = id;
            this.session = session;
        }

        @Override
        public String toString() {
            return "InTx" + this.transactionLevel + "[" + this.id + "]";
        }

        @Override
        public String txID() {
            return this.id;
        }

        @Override
        public YdbTxState withAutoCommit(boolean newAutoCommit) throws SQLException {
            throw new SQLFeatureNotSupportedException("Cannot change transaction isolation inside a transaction");
        }

        @Override
        public YdbTxState withTransactionLevel(int newTransactionLevel) throws SQLException {
            throw new SQLFeatureNotSupportedException("Cannot change transaction isolation inside a transaction");
        }

        @Override
        public YdbTxState withReadOnly(boolean readOnly) throws SQLException {
            throw new SQLFeatureNotSupportedException("Cannot change read-only attribute inside a transaction");
        }

        @Override
        public boolean isInsideTransaction() {
            return true;
        }

        @Override
        public Session getSession(YdbContext ctx, YdbExecutor executor) throws SQLException {
            return this.session;
        }

        @Override
        public YdbTxState withCommit(Session session) {
            session.close();
            return new EmptyTransaction();
        }

        @Override
        public YdbTxState withRollback(Session session) {
            session.close();
            return new EmptyTransaction();
        }

        @Override
        public YdbTxState withKeepAlive(Session session) {
            return this;
        }

        @Override
        public YdbTxState withDataQuery(Session session, String txID) {
            if (txID == null || txID.isEmpty()) {
                if (this.session != session) {
                    session.close();
                }
                this.session.close();
                return new EmptyTransaction();
            }
            if (this.id.equals(txID)) {
                if (this.session == session) {
                    return this;
                }
                this.session.close();
                return new TransactionInProgress(txID, session, this.isAutoCommit());
            }
            session.close();
            return this;
        }
    }

    private static class EmptyTransaction
    extends YdbTxState {
        EmptyTransaction() {
            super(TxControl.serializableRw().setCommitTx(false), 8);
        }

        @Override
        public String toString() {
            return "EmptyTx" + this.transactionLevel;
        }

        @Override
        public YdbTxState withDataQuery(Session session, String txID) {
            if (txID != null && !txID.isEmpty()) {
                return new TransactionInProgress(txID, session, this.isAutoCommit());
            }
            session.close();
            return this;
        }
    }
}

