/*
 * Decompiled with CFR 0.152.
 */
package tech.ydb.jdbc.context;

import java.sql.SQLException;
import java.util.Objects;
import java.util.Properties;
import tech.ydb.jdbc.settings.YdbClientProperties;
import tech.ydb.jdbc.settings.YdbConnectionProperties;
import tech.ydb.jdbc.settings.YdbConnectionProperty;
import tech.ydb.jdbc.settings.YdbJdbcTools;
import tech.ydb.jdbc.settings.YdbOperationProperties;
import tech.ydb.jdbc.settings.YdbProperties;

public class YdbConfig {
    private final String url;
    private final Properties properties;
    private final YdbProperties config;

    public YdbConfig(String url, Properties properties) throws SQLException {
        this.url = url;
        this.properties = properties;
        this.config = YdbJdbcTools.from(url, properties);
    }

    public Properties getSafeProps() {
        Properties safe = new Properties();
        for (String key : this.properties.stringPropertyNames()) {
            if (YdbConfig.isSensetive(key)) {
                safe.put(key, "***");
                continue;
            }
            safe.put(key, this.properties.get(key));
        }
        return safe;
    }

    private static boolean isSensetive(String key) {
        return YdbConnectionProperty.TOKEN.getName().equalsIgnoreCase(key) || "password".equalsIgnoreCase(key);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof YdbConfig)) {
            return false;
        }
        YdbConfig that = (YdbConfig)o;
        return Objects.equals(this.url, that.url) && Objects.equals(this.properties, that.properties);
    }

    public int hashCode() {
        return Objects.hash(this.url, this.properties);
    }

    public String getUrl() {
        return this.url;
    }

    public String getSafeUrl() {
        return this.config.getConnectionProperties().getSafeUrl();
    }

    public YdbConnectionProperties getConnectionProperties() {
        return this.config.getConnectionProperties();
    }

    public YdbClientProperties getClientProperties() {
        return this.config.getClientProperties();
    }

    public YdbOperationProperties getOperationProperties() {
        return this.config.getOperationProperties();
    }
}

