/*
 * Decompiled with CFR 0.152.
 */
package tech.ydb.jdbc.common;

import com.google.common.base.Preconditions;
import java.io.ByteArrayInputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.SQLException;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;
import tech.ydb.jdbc.impl.YdbTypesImpl;
import tech.ydb.table.result.PrimitiveReader;
import tech.ydb.table.result.ValueReader;
import tech.ydb.table.values.DecimalValue;
import tech.ydb.table.values.PrimitiveType;
import tech.ydb.table.values.Type;
import tech.ydb.table.values.Value;

public class MappingGetters {
    static Getters buildGetters(Type type) {
        Type.Kind kind = type.getKind();
        PrimitiveType id = type.getKind() == Type.Kind.PRIMITIVE ? (PrimitiveType)type : null;
        return new Getters(MappingGetters.valueToString(kind, id), MappingGetters.valueToBoolean(kind, id), MappingGetters.valueToByte(kind, id), MappingGetters.valueToShort(kind, id), MappingGetters.valueToInt(kind, id), MappingGetters.valueToLong(kind, id), MappingGetters.valueToFloat(kind, id), MappingGetters.valueToDouble(kind, id), MappingGetters.valueToBytes(kind, id), MappingGetters.valueToObject(kind, id), MappingGetters.valueToDateMillis(kind, id), MappingGetters.valueToNString(kind, id), MappingGetters.valueToURL(kind, id), MappingGetters.valueToBigDecimal(kind, id), MappingGetters.valueToReader(kind, id));
    }

    private static ValueToString valueToString(Type.Kind kind, @Nullable PrimitiveType id) {
        Class<String> javaType = String.class;
        if (kind == Type.Kind.PRIMITIVE) {
            Preconditions.checkState(id != null, "Primitive type must not be null when kind is %s", (Object)kind);
            switch (id) {
                case Bytes: {
                    return value -> new String(value.getBytes());
                }
                case Text: {
                    return PrimitiveReader::getText;
                }
                case Json: {
                    return PrimitiveReader::getJson;
                }
                case JsonDocument: {
                    return PrimitiveReader::getJsonDocument;
                }
                case Yson: {
                    return value -> new String(value.getYson());
                }
                case Uuid: {
                    return value -> String.valueOf(value.getUuid());
                }
                case Bool: {
                    return value -> String.valueOf(value.getBool());
                }
                case Int8: {
                    return value -> String.valueOf(value.getInt8());
                }
                case Uint8: {
                    return value -> String.valueOf(value.getUint8());
                }
                case Int16: {
                    return value -> String.valueOf(value.getInt16());
                }
                case Uint16: {
                    return value -> String.valueOf(value.getUint16());
                }
                case Int32: {
                    return value -> String.valueOf(value.getInt32());
                }
                case Uint32: {
                    return value -> String.valueOf(value.getUint32());
                }
                case Int64: {
                    return value -> String.valueOf(value.getInt64());
                }
                case Uint64: {
                    return value -> String.valueOf(value.getUint64());
                }
                case Float: {
                    return value -> String.valueOf(value.getFloat());
                }
                case Double: {
                    return value -> String.valueOf(value.getDouble());
                }
                case Date: {
                    return value -> String.valueOf(value.getDate());
                }
                case Datetime: {
                    return value -> String.valueOf(value.getDatetime());
                }
                case Timestamp: {
                    return value -> String.valueOf(value.getTimestamp());
                }
                case Interval: {
                    return value -> String.valueOf(value.getInterval());
                }
                case TzDate: {
                    return value -> String.valueOf(value.getTzDate());
                }
                case TzDatetime: {
                    return value -> String.valueOf(value.getTzDatetime());
                }
                case TzTimestamp: {
                    return value -> String.valueOf(value.getTzTimestamp());
                }
            }
            return value -> {
                throw MappingGetters.dataTypeNotSupported(id, javaType);
            };
        }
        if (kind == Type.Kind.DECIMAL) {
            return value -> String.valueOf(value.getDecimal());
        }
        return value -> String.valueOf(value.getValue());
    }

    private static ValueToBoolean valueToBoolean(Type.Kind kind, @Nullable PrimitiveType id) {
        Class<Boolean> javaType = Boolean.TYPE;
        if (kind == Type.Kind.PRIMITIVE) {
            Preconditions.checkState(id != null, "Primitive type must not be null when kind is %s", (Object)kind);
            switch (id) {
                case Bool: {
                    return PrimitiveReader::getBool;
                }
                case Int8: {
                    return value -> value.getInt8() != 0;
                }
                case Uint8: {
                    return value -> value.getUint8() != 0;
                }
                case Int16: {
                    return value -> value.getInt16() != 0;
                }
                case Uint16: {
                    return value -> value.getUint16() != 0;
                }
                case Int32: {
                    return value -> value.getInt32() != 0;
                }
                case Uint32: {
                    return value -> value.getUint32() != 0L;
                }
                case Int64: {
                    return value -> value.getInt64() != 0L;
                }
                case Uint64: {
                    return value -> value.getUint64() != 0L;
                }
                case Bytes: {
                    return value -> {
                        byte[] stringValue = value.getBytes();
                        if (stringValue.length == 0) {
                            return false;
                        }
                        if (stringValue.length == 1) {
                            if (stringValue[0] == 48) {
                                return false;
                            }
                            if (stringValue[0] == 49) {
                                return true;
                            }
                        }
                        throw MappingGetters.cannotConvert(id, javaType, new String(stringValue));
                    };
                }
                case Text: {
                    return value -> {
                        String utfValue = value.getText();
                        if (utfValue.isEmpty()) {
                            return false;
                        }
                        if (utfValue.length() == 1) {
                            if (utfValue.charAt(0) == '0') {
                                return false;
                            }
                            if (utfValue.charAt(0) == '1') {
                                return true;
                            }
                        }
                        throw MappingGetters.cannotConvert(id, javaType, utfValue);
                    };
                }
            }
            return value -> {
                throw MappingGetters.dataTypeNotSupported(id, javaType);
            };
        }
        return value -> {
            throw MappingGetters.dataTypeNotSupported(kind, javaType);
        };
    }

    private static byte checkByteValue(PrimitiveType id, int value) throws SQLException {
        int ch;
        int n = ch = value >= 0 ? value : ~value;
        if ((ch & 0x7F) != ch) {
            throw MappingGetters.cannotConvert(id, Byte.TYPE, value);
        }
        return (byte)value;
    }

    private static byte checkByteValue(PrimitiveType id, long value) throws SQLException {
        long ch;
        long l = ch = value >= 0L ? value : value ^ 0xFFFFFFFFFFFFFFFFL;
        if ((ch & 0x7FL) != ch) {
            throw MappingGetters.cannotConvert(id, Byte.TYPE, value);
        }
        return (byte)value;
    }

    private static ValueToByte valueToByte(Type.Kind kind, PrimitiveType id) {
        if (kind == Type.Kind.PRIMITIVE) {
            Preconditions.checkState(id != null, "Primitive type must not be null when kind is %s", (Object)kind);
            switch (id) {
                case Bool: {
                    return value -> MappingGetters.checkByteValue(id, value.getBool() ? 1 : 0);
                }
                case Int8: {
                    return PrimitiveReader::getInt8;
                }
                case Int16: {
                    return value -> MappingGetters.checkByteValue(id, value.getInt16());
                }
                case Int32: {
                    return value -> MappingGetters.checkByteValue(id, value.getInt32());
                }
                case Int64: {
                    return value -> MappingGetters.checkByteValue(id, value.getInt64());
                }
                case Uint8: {
                    return value -> MappingGetters.checkByteValue(id, value.getUint8());
                }
                case Uint16: {
                    return value -> MappingGetters.checkByteValue(id, value.getUint16());
                }
                case Uint32: {
                    return value -> MappingGetters.checkByteValue(id, value.getUint32());
                }
                case Uint64: {
                    return value -> MappingGetters.checkByteValue(id, value.getUint64());
                }
            }
            return value -> {
                throw MappingGetters.dataTypeNotSupported(id, Byte.TYPE);
            };
        }
        return value -> {
            throw MappingGetters.dataTypeNotSupported(kind, Byte.TYPE);
        };
    }

    private static short checkShortValue(PrimitiveType id, int value) throws SQLException {
        int ch;
        int n = ch = value >= 0 ? value : ~value;
        if ((ch & Short.MAX_VALUE) != ch) {
            throw MappingGetters.cannotConvert(id, Short.TYPE, value);
        }
        return (short)value;
    }

    private static short checkShortValue(PrimitiveType id, long value) throws SQLException {
        long ch;
        long l = ch = value >= 0L ? value : value ^ 0xFFFFFFFFFFFFFFFFL;
        if ((ch & 0x7FFFL) != ch) {
            throw MappingGetters.cannotConvert(id, Short.TYPE, value);
        }
        return (short)value;
    }

    private static ValueToShort valueToShort(Type.Kind kind, PrimitiveType id) {
        if (kind == Type.Kind.PRIMITIVE) {
            Preconditions.checkState(id != null, "Primitive type must not be null when kind is %s", (Object)kind);
            switch (id) {
                case Bool: {
                    return value -> MappingGetters.checkShortValue(id, value.getBool() ? 1 : 0);
                }
                case Int8: {
                    return PrimitiveReader::getInt8;
                }
                case Int16: {
                    return PrimitiveReader::getInt16;
                }
                case Int32: {
                    return value -> MappingGetters.checkShortValue(id, value.getInt32());
                }
                case Int64: {
                    return value -> MappingGetters.checkShortValue(id, value.getInt64());
                }
                case Uint8: {
                    return value -> MappingGetters.checkShortValue(id, value.getUint8());
                }
                case Uint16: {
                    return value -> MappingGetters.checkShortValue(id, value.getUint16());
                }
                case Uint32: {
                    return value -> MappingGetters.checkShortValue(id, value.getUint32());
                }
                case Uint64: {
                    return value -> MappingGetters.checkShortValue(id, value.getUint64());
                }
            }
            return value -> {
                throw MappingGetters.dataTypeNotSupported(id, Short.TYPE);
            };
        }
        return value -> {
            throw MappingGetters.dataTypeNotSupported(kind, Short.TYPE);
        };
    }

    private static int checkIntValue(PrimitiveType id, long value) throws SQLException {
        long ch;
        long l = ch = value >= 0L ? value : value ^ 0xFFFFFFFFFFFFFFFFL;
        if ((ch & Integer.MAX_VALUE) != ch) {
            throw MappingGetters.cannotConvert(id, Integer.TYPE, value);
        }
        return (int)value;
    }

    private static ValueToInt valueToInt(Type.Kind kind, PrimitiveType id) {
        if (kind == Type.Kind.PRIMITIVE) {
            Preconditions.checkState(id != null, "Primitive type must not be null when kind is %s", (Object)kind);
            switch (id) {
                case Bool: {
                    return value -> value.getBool() ? 1 : 0;
                }
                case Int8: {
                    return PrimitiveReader::getInt8;
                }
                case Int16: {
                    return PrimitiveReader::getInt16;
                }
                case Int32: {
                    return PrimitiveReader::getInt32;
                }
                case Int64: {
                    return value -> MappingGetters.checkIntValue(id, value.getInt64());
                }
                case Uint8: {
                    return PrimitiveReader::getUint8;
                }
                case Uint16: {
                    return PrimitiveReader::getUint16;
                }
                case Uint32: {
                    return value -> MappingGetters.checkIntValue(id, value.getUint32());
                }
                case Uint64: {
                    return value -> MappingGetters.checkIntValue(id, value.getUint64());
                }
            }
            return value -> {
                throw MappingGetters.dataTypeNotSupported(id, Integer.TYPE);
            };
        }
        if (kind == Type.Kind.DECIMAL) {
            return value -> value.getDecimal().toBigInteger().intValue();
        }
        return value -> {
            throw MappingGetters.dataTypeNotSupported(kind, Integer.TYPE);
        };
    }

    private static ValueToLong valueToLong(Type.Kind kind, @Nullable PrimitiveType id) {
        if (kind == Type.Kind.PRIMITIVE) {
            Preconditions.checkState(id != null, "Primitive type must not be null when kind is %s", (Object)kind);
            switch (id) {
                case Bool: {
                    return value -> value.getBool() ? 1L : 0L;
                }
                case Int8: {
                    return PrimitiveReader::getInt8;
                }
                case Uint8: {
                    return PrimitiveReader::getUint8;
                }
                case Int16: {
                    return PrimitiveReader::getInt16;
                }
                case Uint16: {
                    return PrimitiveReader::getUint16;
                }
                case Int32: {
                    return PrimitiveReader::getInt32;
                }
                case Uint32: {
                    return PrimitiveReader::getUint32;
                }
                case Int64: {
                    return PrimitiveReader::getInt64;
                }
                case Uint64: {
                    return PrimitiveReader::getUint64;
                }
                case Date: 
                case Datetime: 
                case Timestamp: 
                case TzDate: 
                case TzDatetime: 
                case TzTimestamp: {
                    ValueToDateMillis delegate = MappingGetters.valueToDateMillis(kind, id);
                    return delegate::fromValue;
                }
                case Interval: {
                    return value -> TimeUnit.NANOSECONDS.toMicros(value.getInterval().toNanos());
                }
            }
            return value -> {
                throw MappingGetters.dataTypeNotSupported(id, Long.TYPE);
            };
        }
        if (kind == Type.Kind.DECIMAL) {
            return value -> value.getDecimal().toBigInteger().longValue();
        }
        return value -> {
            throw MappingGetters.dataTypeNotSupported(kind, Long.TYPE);
        };
    }

    private static ValueToFloat valueToFloat(Type.Kind kind, @Nullable PrimitiveType id) {
        Class<Float> javaType = Float.TYPE;
        if (kind == Type.Kind.PRIMITIVE) {
            Preconditions.checkState(id != null, "Primitive type must not be null when kind is %s", (Object)kind);
            switch (id) {
                case Bool: {
                    return value -> value.getBool() ? 1.0f : 0.0f;
                }
                case Int8: {
                    return PrimitiveReader::getInt8;
                }
                case Int16: {
                    return PrimitiveReader::getInt16;
                }
                case Int32: {
                    return PrimitiveReader::getInt32;
                }
                case Int64: {
                    return PrimitiveReader::getInt64;
                }
                case Uint8: {
                    return PrimitiveReader::getUint8;
                }
                case Uint16: {
                    return PrimitiveReader::getUint16;
                }
                case Uint32: {
                    return PrimitiveReader::getUint32;
                }
                case Uint64: {
                    return PrimitiveReader::getUint64;
                }
                case Float: {
                    return PrimitiveReader::getFloat;
                }
                case Double: {
                    return value -> (float)value.getDouble();
                }
            }
            return value -> {
                throw MappingGetters.dataTypeNotSupported(id, javaType);
            };
        }
        if (kind == Type.Kind.DECIMAL) {
            return value -> value.getDecimal().toBigDecimal().floatValue();
        }
        return value -> {
            throw MappingGetters.dataTypeNotSupported(kind, javaType);
        };
    }

    private static ValueToDouble valueToDouble(Type.Kind kind, @Nullable PrimitiveType id) {
        Class<Double> javaType = Double.TYPE;
        if (kind == Type.Kind.PRIMITIVE) {
            Preconditions.checkState(id != null, "Primitive type must not be null when kind is %s", (Object)kind);
            switch (id) {
                case Bool: {
                    return value -> value.getBool() ? 1.0 : 0.0;
                }
                case Int8: {
                    return PrimitiveReader::getInt8;
                }
                case Uint8: {
                    return PrimitiveReader::getUint8;
                }
                case Int16: {
                    return PrimitiveReader::getInt16;
                }
                case Uint16: {
                    return PrimitiveReader::getUint16;
                }
                case Int32: {
                    return PrimitiveReader::getInt32;
                }
                case Uint32: {
                    return PrimitiveReader::getUint32;
                }
                case Int64: {
                    return PrimitiveReader::getInt64;
                }
                case Uint64: {
                    return PrimitiveReader::getUint64;
                }
                case Float: {
                    return PrimitiveReader::getFloat;
                }
                case Double: {
                    return PrimitiveReader::getDouble;
                }
            }
            return value -> {
                throw MappingGetters.dataTypeNotSupported(id, javaType);
            };
        }
        if (kind == Type.Kind.DECIMAL) {
            return value -> value.getDecimal().toBigDecimal().doubleValue();
        }
        return value -> {
            throw MappingGetters.dataTypeNotSupported(kind, javaType);
        };
    }

    private static ValueToBytes valueToBytes(Type.Kind kind, @Nullable PrimitiveType id) {
        Class<byte[]> javaType = byte[].class;
        if (kind == Type.Kind.PRIMITIVE) {
            Preconditions.checkState(id != null, "Primitive type must not be null when kind is %s", (Object)kind);
            switch (id) {
                case Bytes: {
                    return PrimitiveReader::getBytes;
                }
                case Text: {
                    return value -> value.getText().getBytes();
                }
                case Json: {
                    return value -> value.getJson().getBytes();
                }
                case JsonDocument: {
                    return value -> value.getJsonDocument().getBytes();
                }
                case Yson: {
                    return PrimitiveReader::getYson;
                }
                case Uuid: {
                    return value -> value.getUuid().toString().getBytes();
                }
            }
            return value -> {
                throw MappingGetters.dataTypeNotSupported(id, javaType);
            };
        }
        return value -> {
            throw MappingGetters.dataTypeNotSupported(kind, javaType);
        };
    }

    private static ValueToDateMillis valueToDateMillis(Type.Kind kind, @Nullable PrimitiveType id) {
        Class<Long> javaType = Long.TYPE;
        if (kind == Type.Kind.PRIMITIVE) {
            Preconditions.checkState(id != null, "Primitive type must not be null when kind is %s", (Object)kind);
            switch (id) {
                case Int64: {
                    return PrimitiveReader::getInt64;
                }
                case Uint64: {
                    return PrimitiveReader::getUint64;
                }
                case Date: {
                    return value -> TimeUnit.DAYS.toMillis(value.getDate().toEpochDay());
                }
                case Datetime: {
                    return value -> TimeUnit.SECONDS.toMillis(value.getDatetime().toEpochSecond(ZoneOffset.UTC));
                }
                case TzDate: {
                    return value -> TimeUnit.SECONDS.toMillis(value.getTzDate().toEpochSecond());
                }
                case TzDatetime: {
                    return value -> TimeUnit.SECONDS.toMillis(value.getTzDatetime().toEpochSecond());
                }
                case Timestamp: {
                    return value -> value.getTimestamp().toEpochMilli();
                }
                case TzTimestamp: {
                    return value -> TimeUnit.SECONDS.toMillis(value.getTzTimestamp().toEpochSecond());
                }
            }
            return value -> {
                throw MappingGetters.dataTypeNotSupported(id, javaType);
            };
        }
        return value -> {
            throw MappingGetters.dataTypeNotSupported(kind, javaType);
        };
    }

    private static ValueToNString valueToNString(Type.Kind kind, @Nullable PrimitiveType id) {
        Class<String> javaType = String.class;
        if (kind == Type.Kind.PRIMITIVE) {
            Preconditions.checkState(id != null, "Primitive type must not be null when kind is %s", (Object)kind);
            switch (id) {
                case Bytes: {
                    return value -> new String(value.getBytes());
                }
                case Text: {
                    return PrimitiveReader::getText;
                }
                case Json: {
                    return PrimitiveReader::getJson;
                }
                case JsonDocument: {
                    return PrimitiveReader::getJsonDocument;
                }
                case Yson: {
                    return value -> new String(value.getYson());
                }
                case Uuid: {
                    return value -> String.valueOf(value.getUuid());
                }
            }
            return value -> {
                throw MappingGetters.dataTypeNotSupported(id, javaType);
            };
        }
        return value -> {
            throw MappingGetters.dataTypeNotSupported(kind, javaType);
        };
    }

    private static ValueToURL valueToURL(Type.Kind kind, @Nullable PrimitiveType id) {
        Class<URL> javaType = URL.class;
        if (kind == Type.Kind.PRIMITIVE) {
            Preconditions.checkState(id != null, "Primitive type must not be null when kind is %s", (Object)kind);
            switch (id) {
                case Bytes: {
                    return value -> new String(value.getBytes());
                }
                case Text: {
                    return PrimitiveReader::getText;
                }
            }
            return value -> {
                throw MappingGetters.dataTypeNotSupported(id, javaType);
            };
        }
        return value -> {
            throw MappingGetters.dataTypeNotSupported(kind, javaType);
        };
    }

    private static ValueToBigDecimal valueToBigDecimal(Type.Kind kind, @Nullable PrimitiveType id) {
        Class<BigDecimal> javaType = BigDecimal.class;
        if (kind == Type.Kind.PRIMITIVE) {
            Preconditions.checkState(id != null, "Primitive type must not be null when kind is %s", (Object)kind);
            switch (id) {
                case Bool: {
                    return value -> BigDecimal.valueOf(value.getBool() ? 1L : 0L);
                }
                case Int8: {
                    return value -> BigDecimal.valueOf(value.getInt8());
                }
                case Uint8: {
                    return value -> BigDecimal.valueOf(value.getUint8());
                }
                case Int16: {
                    return value -> BigDecimal.valueOf(value.getInt16());
                }
                case Uint16: {
                    return value -> BigDecimal.valueOf(value.getUint16());
                }
                case Int32: {
                    return value -> BigDecimal.valueOf(value.getInt32());
                }
                case Uint32: {
                    return value -> BigDecimal.valueOf(value.getUint32());
                }
                case Int64: {
                    return value -> BigDecimal.valueOf(value.getInt64());
                }
                case Uint64: {
                    return value -> BigDecimal.valueOf(value.getUint64());
                }
                case Float: {
                    return value -> BigDecimal.valueOf(value.getFloat());
                }
                case Double: {
                    return value -> BigDecimal.valueOf(value.getDouble());
                }
            }
            return value -> {
                throw MappingGetters.dataTypeNotSupported(id, javaType);
            };
        }
        if (kind == Type.Kind.DECIMAL) {
            return value -> value.getDecimal().toBigDecimal();
        }
        return value -> {
            throw MappingGetters.dataTypeNotSupported(kind, javaType);
        };
    }

    private static ValueToReader valueToReader(Type.Kind kind, @Nullable PrimitiveType id) {
        Class<Reader> javaType = Reader.class;
        if (kind == Type.Kind.PRIMITIVE) {
            Preconditions.checkState(id != null, "Primitive type must not be null when kind is %s", (Object)kind);
            switch (id) {
                case Bytes: {
                    return value -> new InputStreamReader(new ByteArrayInputStream(value.getBytes()));
                }
                case Text: {
                    return value -> new StringReader(value.getText());
                }
                case Json: {
                    return value -> new StringReader(value.getJson());
                }
                case JsonDocument: {
                    return value -> new StringReader(value.getJsonDocument());
                }
                case Yson: {
                    return value -> new InputStreamReader(new ByteArrayInputStream(value.getYson()));
                }
                case Uuid: {
                    return value -> new StringReader(value.getUuid().toString());
                }
            }
            return value -> {
                throw MappingGetters.dataTypeNotSupported(id, javaType);
            };
        }
        return value -> {
            throw MappingGetters.dataTypeNotSupported(kind, javaType);
        };
    }

    static SqlType buildDataType(Type type) {
        Type.Kind kind = type.getKind();
        int sqlType = YdbTypesImpl.getInstance().toSqlType(type);
        if (kind == Type.Kind.PRIMITIVE) {
            Class javaType;
            PrimitiveType id = (PrimitiveType)type;
            switch (id) {
                case Text: 
                case Json: 
                case JsonDocument: 
                case Uuid: {
                    javaType = String.class;
                    break;
                }
                case Bytes: 
                case Yson: {
                    javaType = byte[].class;
                    break;
                }
                case Bool: {
                    javaType = Boolean.class;
                    break;
                }
                case Int8: {
                    javaType = Byte.class;
                    break;
                }
                case Uint8: 
                case Uint16: 
                case Int32: {
                    javaType = Integer.class;
                    break;
                }
                case Int16: {
                    javaType = Short.class;
                    break;
                }
                case Uint32: 
                case Int64: 
                case Uint64: {
                    javaType = Long.class;
                    break;
                }
                case Float: {
                    javaType = Float.class;
                    break;
                }
                case Double: {
                    javaType = Double.class;
                    break;
                }
                case Date: {
                    javaType = LocalDate.class;
                    break;
                }
                case Datetime: {
                    javaType = LocalDateTime.class;
                    break;
                }
                case Timestamp: {
                    javaType = Instant.class;
                    break;
                }
                case Interval: {
                    javaType = Duration.class;
                    break;
                }
                case TzDate: 
                case TzDatetime: 
                case TzTimestamp: {
                    javaType = ZonedDateTime.class;
                    break;
                }
                default: {
                    javaType = Value.class;
                }
            }
            return new SqlType(sqlType, javaType);
        }
        if (kind == Type.Kind.DECIMAL) {
            return new SqlType(sqlType, DecimalValue.class);
        }
        return new SqlType(sqlType, Value.class);
    }

    private static ValueToObject valueToObject(Type.Kind kind, @Nullable PrimitiveType id) {
        Class<Object> javaType = Object.class;
        if (kind == Type.Kind.PRIMITIVE) {
            Preconditions.checkState(id != null, "Primitive type must not be null when kind is %s", (Object)kind);
            switch (id) {
                case Bytes: {
                    return PrimitiveReader::getBytes;
                }
                case Text: {
                    return PrimitiveReader::getText;
                }
                case Json: {
                    return PrimitiveReader::getJson;
                }
                case JsonDocument: {
                    return PrimitiveReader::getJsonDocument;
                }
                case Yson: {
                    return PrimitiveReader::getYson;
                }
                case Uuid: {
                    return PrimitiveReader::getUuid;
                }
                case Bool: {
                    return PrimitiveReader::getBool;
                }
                case Int8: {
                    return PrimitiveReader::getInt8;
                }
                case Uint8: {
                    return PrimitiveReader::getUint8;
                }
                case Int16: {
                    return PrimitiveReader::getInt16;
                }
                case Uint16: {
                    return PrimitiveReader::getUint16;
                }
                case Int32: {
                    return PrimitiveReader::getInt32;
                }
                case Uint32: {
                    return PrimitiveReader::getUint32;
                }
                case Int64: {
                    return PrimitiveReader::getInt64;
                }
                case Uint64: {
                    return PrimitiveReader::getUint64;
                }
                case Float: {
                    return PrimitiveReader::getFloat;
                }
                case Double: {
                    return PrimitiveReader::getDouble;
                }
                case Date: {
                    return PrimitiveReader::getDate;
                }
                case Datetime: {
                    return PrimitiveReader::getDatetime;
                }
                case Timestamp: {
                    return PrimitiveReader::getTimestamp;
                }
                case Interval: {
                    return PrimitiveReader::getInterval;
                }
                case TzDate: {
                    return PrimitiveReader::getTzDate;
                }
                case TzDatetime: {
                    return PrimitiveReader::getTzDatetime;
                }
                case TzTimestamp: {
                    return PrimitiveReader::getTzTimestamp;
                }
            }
            return value -> {
                throw MappingGetters.dataTypeNotSupported(id, javaType);
            };
        }
        if (kind == Type.Kind.DECIMAL) {
            return PrimitiveReader::getDecimal;
        }
        return ValueReader::getValue;
    }

    private static SQLException cannotConvert(PrimitiveType type, Class<?> javaType, Object value) {
        return new SQLException(String.format("Cannot cast [%s] with value [%s] to [%s]", type, value, javaType));
    }

    private static SQLException dataTypeNotSupported(PrimitiveType type, Class<?> javaType) {
        return new SQLException(String.format("Cannot cast [%s] to [%s]", type, javaType));
    }

    private static SQLException dataTypeNotSupported(Type.Kind kind, Class<?> javaType) {
        return new SQLException(String.format("Cannot cast [%s] to [%s]", new Object[]{kind, javaType}));
    }

    public static class SqlType {
        private final int sqlType;
        private final Class<?> javaType;

        SqlType(int sqlType, Class<?> javaType) {
            this.sqlType = sqlType;
            this.javaType = Objects.requireNonNull(javaType);
        }

        public int getSqlType() {
            return this.sqlType;
        }

        public Class<?> getJavaType() {
            return this.javaType;
        }
    }

    public static interface ValueToReader {
        public Reader fromValue(ValueReader var1) throws SQLException;
    }

    public static interface ValueToBigDecimal {
        public BigDecimal fromValue(ValueReader var1) throws SQLException;
    }

    public static interface ValueToURL {
        public String fromValue(ValueReader var1) throws SQLException;
    }

    public static interface ValueToNString {
        public String fromValue(ValueReader var1) throws SQLException;
    }

    public static interface ValueToDateMillis {
        public long fromValue(ValueReader var1) throws SQLException;
    }

    public static interface ValueToObject {
        public Object fromValue(ValueReader var1) throws SQLException;
    }

    public static interface ValueToBytes {
        public byte[] fromValue(ValueReader var1) throws SQLException;
    }

    public static interface ValueToDouble {
        public double fromValue(ValueReader var1) throws SQLException;
    }

    public static interface ValueToFloat {
        public float fromValue(ValueReader var1) throws SQLException;
    }

    public static interface ValueToLong {
        public long fromValue(ValueReader var1) throws SQLException;
    }

    public static interface ValueToInt {
        public int fromValue(ValueReader var1) throws SQLException;
    }

    public static interface ValueToShort {
        public short fromValue(ValueReader var1) throws SQLException;
    }

    public static interface ValueToByte {
        public byte fromValue(ValueReader var1) throws SQLException;
    }

    public static interface ValueToBoolean {
        public boolean fromValue(ValueReader var1) throws SQLException;
    }

    public static interface ValueToString {
        public String fromValue(ValueReader var1) throws SQLException;
    }

    public static class Getters {
        public final ValueToString toString;
        public final ValueToBoolean toBoolean;
        public final ValueToByte toByte;
        public final ValueToShort toShort;
        public final ValueToInt toInt;
        public final ValueToLong toLong;
        public final ValueToFloat toFloat;
        public final ValueToDouble toDouble;
        public final ValueToBytes toBytes;
        public final ValueToObject toObject;
        public final ValueToDateMillis toDateMillis;
        public final ValueToNString toNString;
        public final ValueToURL toURL;
        public final ValueToBigDecimal toBigDecimal;
        public final ValueToReader toReader;

        Getters(ValueToString toString, ValueToBoolean toBoolean, ValueToByte toByte, ValueToShort toShort, ValueToInt toInt, ValueToLong toLong, ValueToFloat toFloat, ValueToDouble toDouble, ValueToBytes toBytes, ValueToObject toObject, ValueToDateMillis toDateMillis, ValueToNString toNString, ValueToURL toURL, ValueToBigDecimal toBigDecimal, ValueToReader toReader) {
            this.toString = toString;
            this.toBoolean = toBoolean;
            this.toByte = toByte;
            this.toShort = toShort;
            this.toInt = toInt;
            this.toLong = toLong;
            this.toFloat = toFloat;
            this.toDouble = toDouble;
            this.toBytes = toBytes;
            this.toObject = toObject;
            this.toDateMillis = toDateMillis;
            this.toNString = toNString;
            this.toURL = toURL;
            this.toBigDecimal = toBigDecimal;
            this.toReader = toReader;
        }
    }
}

