/*
 * Decompiled with CFR 0.152.
 */
package tech.ydb.jdbc.common;

import com.google.common.base.Preconditions;
import java.io.FilterReader;
import java.io.IOException;
import java.io.Reader;

final class LimitedReader
extends FilterReader {
    private long left;
    private long mark = -1L;

    LimitedReader(Reader in, long limit) {
        super(in);
        Preconditions.checkNotNull(in);
        Preconditions.checkArgument(limit >= 0L, "limit must be non-negative");
        this.left = limit;
    }

    @Override
    public synchronized void mark(int readLimit) throws IOException {
        this.in.mark(readLimit);
        this.mark = this.left;
    }

    @Override
    public int read() throws IOException {
        if (this.left == 0L) {
            return -1;
        }
        int result = this.in.read();
        if (result != -1) {
            --this.left;
        }
        return result;
    }

    @Override
    public int read(char[] cbuf, int off, int len) throws IOException {
        if (this.left == 0L) {
            return -1;
        }
        int result = this.in.read(cbuf, off, len = (int)Math.min((long)len, this.left));
        if (result != -1) {
            this.left -= (long)result;
        }
        return result;
    }

    @Override
    public synchronized void reset() throws IOException {
        if (!this.in.markSupported()) {
            throw new IOException("Mark not supported");
        }
        if (this.mark == -1L) {
            throw new IOException("Mark not set");
        }
        this.in.reset();
        this.left = this.mark;
    }

    @Override
    public long skip(long n) throws IOException {
        n = Math.min(n, this.left);
        long skipped = this.in.skip(n);
        this.left -= skipped;
        return skipped;
    }
}

