/*
 * Decompiled with CFR 0.152.
 */
package tech.ydb.core.impl.pool;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Ticker;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import tech.ydb.core.grpc.BalancingSettings;
import tech.ydb.core.impl.pool.EndpointPool;
import tech.ydb.proto.discovery.DiscoveryProtos;

public class EndpointPriorityFactory {
    private static final Logger logger = LoggerFactory.getLogger(EndpointPriorityFactory.class);
    private static final int LOCALITY_SHIFT = 1000;
    private static final int NODE_SIZE = 3;
    private static final int TCP_PING_TIMEOUT_MS = 5000;
    private final String locationDC;

    public EndpointPriorityFactory(BalancingSettings settings, DiscoveryProtos.ListEndpointsResult endpointsResult) {
        this(settings, endpointsResult, Ticker.systemTicker());
    }

    @VisibleForTesting
    EndpointPriorityFactory(BalancingSettings settings, DiscoveryProtos.ListEndpointsResult endpointsResult, Ticker ticker) {
        switch (settings.getPolicy()) {
            case USE_ALL_NODES: {
                this.locationDC = null;
                break;
            }
            case USE_PREFERABLE_LOCATION: {
                String preferred = settings.getPreferableLocation();
                if (preferred == null || preferred.isEmpty()) {
                    preferred = endpointsResult.getSelfLocation();
                }
                this.locationDC = preferred;
                break;
            }
            case USE_DETECT_LOCAL_DC: {
                this.locationDC = EndpointPriorityFactory.detectLocalDC(endpointsResult, ticker);
                break;
            }
            default: {
                throw new RuntimeException("Not implemented balancing policy: " + settings.getPolicy().name());
            }
        }
    }

    public EndpointPool.PriorityEndpoint createEndpoint(DiscoveryProtos.EndpointInfo endpointInfo) {
        return new EndpointPool.PriorityEndpoint(endpointInfo, this.locationDC == null ? 0L : (this.locationDC.equalsIgnoreCase(endpointInfo.getLocation()) ? 0L : 1000L));
    }

    private static String detectLocalDC(DiscoveryProtos.ListEndpointsResult endpointsResult, Ticker ticker) {
        Map<String, List<DiscoveryProtos.EndpointInfo>> dcLocationToNodes = endpointsResult.getEndpointsList().stream().collect(Collectors.groupingBy(DiscoveryProtos.EndpointInfo::getLocation));
        if (dcLocationToNodes.size() < 2) {
            return null;
        }
        long minPing = Long.MAX_VALUE;
        String localDC = null;
        for (Map.Entry<String, List<DiscoveryProtos.EndpointInfo>> entry : dcLocationToNodes.entrySet()) {
            String dc = entry.getKey();
            List<DiscoveryProtos.EndpointInfo> nodes = entry.getValue();
            assert (!nodes.isEmpty());
            Collections.shuffle(nodes);
            int nodeSize = Math.min(nodes.size(), 3);
            long tcpPing = 0L;
            for (DiscoveryProtos.EndpointInfo node : nodes.subList(0, nodeSize)) {
                long currentPing = EndpointPriorityFactory.tcpPing(new InetSocketAddress(node.getAddress(), node.getPort()), ticker);
                logger.debug("Address: {}, port: {}, nanos ping: {}", node.getAddress(), node.getPort(), currentPing);
                tcpPing += currentPing;
            }
            if (minPing <= (tcpPing /= (long)nodeSize)) continue;
            minPing = tcpPing;
            localDC = dc;
        }
        return localDC;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static long tcpPing(InetSocketAddress socketAddress, Ticker ticker) {
        try (Socket socket = new Socket();){
            long startConnection = ticker.read();
            socket.connect(socketAddress, 5000);
            long stopConnection = ticker.read();
            long l = stopConnection - startConnection;
            return l;
        }
        catch (IOException e) {
            return 10000000000L;
        }
    }
}

