/*
 * Decompiled with CFR 0.152.
 */
package tech.ydb.core.impl.call;

import io.grpc.ClientCall;
import io.grpc.Metadata;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import tech.ydb.core.Status;
import tech.ydb.core.grpc.GrpcReadStream;
import tech.ydb.core.grpc.GrpcStatuses;
import tech.ydb.core.impl.call.GrpcStatusHandler;

public class ReadStreamCall<ReqT, RespT>
extends ClientCall.Listener<RespT>
implements GrpcReadStream<RespT> {
    private static final Logger logger = LoggerFactory.getLogger(ReadStreamCall.class);
    private final ClientCall<ReqT, RespT> call;
    private final GrpcStatusHandler statusConsumer;
    private final ReqT request;
    private final Metadata headers;
    private final CompletableFuture<Status> statusFuture = new CompletableFuture();
    private final AtomicReference<GrpcReadStream.Observer<RespT>> observerReference = new AtomicReference();

    public ReadStreamCall(ClientCall<ReqT, RespT> call, ReqT request, Metadata headers, GrpcStatusHandler statusConsumer) {
        this.call = call;
        this.request = request;
        this.headers = headers != null ? headers : new Metadata();
        this.statusConsumer = statusConsumer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CompletableFuture<Status> start(GrpcReadStream.Observer<RespT> observer) {
        if (!this.observerReference.compareAndSet(null, observer)) {
            throw new IllegalStateException("Read stream call is already started");
        }
        ClientCall<ReqT, RespT> clientCall = this.call;
        synchronized (clientCall) {
            try {
                this.call.start(this, this.headers);
                this.call.request(1);
                this.call.sendMessage(this.request);
                this.call.halfClose();
            }
            catch (Throwable t) {
                try {
                    this.call.cancel(null, t);
                }
                catch (Throwable ex) {
                    logger.error("Exception encountered while closing the unary call", ex);
                }
                this.statusFuture.completeExceptionally(t);
            }
        }
        return this.statusFuture;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void cancel() {
        ClientCall<ReqT, RespT> clientCall = this.call;
        synchronized (clientCall) {
            this.call.cancel("Cancelled on user request", new CancellationException());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onMessage(RespT message) {
        try {
            this.observerReference.get().onNext(message);
            ClientCall<ReqT, RespT> clientCall = this.call;
            synchronized (clientCall) {
                this.call.request(1);
            }
        }
        catch (Exception ex) {
            this.statusFuture.completeExceptionally(ex);
            try {
                ClientCall<ReqT, RespT> clientCall = this.call;
                synchronized (clientCall) {
                    this.call.cancel("Canceled by exception from observer", ex);
                }
            }
            catch (Throwable th) {
                logger.error("Exception encountered while canceling the read stream call", th);
            }
        }
    }

    @Override
    public void onClose(io.grpc.Status status, @Nullable Metadata trailers) {
        this.statusConsumer.accept(status, trailers);
        if (status.isOk()) {
            this.statusFuture.complete(Status.SUCCESS);
        } else {
            this.statusFuture.complete(GrpcStatuses.toStatus(status));
        }
    }
}

