/*
 * Decompiled with CFR 0.152.
 */
package tech.ydb.core.impl.call;

import java.util.concurrent.CompletableFuture;
import tech.ydb.core.Status;
import tech.ydb.core.grpc.GrpcReadStream;

public class ProxyReadStream<BaseR, DestR>
implements GrpcReadStream<DestR> {
    private final GrpcReadStream<BaseR> origin;
    private final MessageFunctor<BaseR, DestR> functor;
    private final CompletableFuture<Status> future = new CompletableFuture();

    public ProxyReadStream(GrpcReadStream<BaseR> origin, MessageFunctor<BaseR, DestR> functor) {
        this.origin = origin;
        this.functor = functor;
    }

    @Override
    public CompletableFuture<Status> start(GrpcReadStream.Observer<DestR> observer) {
        this.origin.start((R response) -> this.functor.apply(response, this.future, observer)).whenComplete((status, th) -> {
            if (th != null) {
                this.future.completeExceptionally((Throwable)th);
            }
            if (status != null) {
                this.future.complete((Status)status);
            }
        });
        return this.future;
    }

    @Override
    public void cancel() {
        this.origin.cancel();
    }

    public static interface MessageFunctor<BaseR, DestR> {
        public void apply(BaseR var1, CompletableFuture<Status> var2, GrpcReadStream.Observer<DestR> var3);
    }
}

