/*
 * Decompiled with CFR 0.152.
 */
package tech.ydb.core.impl.auth;

import com.google.common.util.concurrent.MoreExecutors;
import io.grpc.CallOptions;
import java.util.List;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import tech.ydb.auth.AuthIdentity;
import tech.ydb.core.grpc.GrpcCompression;
import tech.ydb.core.grpc.GrpcTransportBuilder;
import tech.ydb.core.impl.auth.GrpcAuthRpc;
import tech.ydb.core.impl.auth.YdbCallCredentials;
import tech.ydb.core.impl.pool.EndpointRecord;
import tech.ydb.core.impl.pool.ManagedChannelFactory;

public class AuthCallOptions
implements AutoCloseable {
    private final AuthIdentity authIdentity;
    private final CallOptions callOptions;
    private final long readTimeoutMillis;

    public AuthCallOptions() {
        this.authIdentity = null;
        this.callOptions = CallOptions.DEFAULT;
        this.readTimeoutMillis = 0L;
    }

    public AuthCallOptions(ScheduledExecutorService scheduler, String database, List<EndpointRecord> endpoints, ManagedChannelFactory channelFactory, GrpcTransportBuilder transportBuilder) {
        CallOptions options = CallOptions.DEFAULT;
        if (transportBuilder.getAuthProvider() != null) {
            GrpcAuthRpc rpc = new GrpcAuthRpc(endpoints, scheduler, database, channelFactory);
            this.authIdentity = transportBuilder.getAuthProvider().createAuthIdentity(rpc);
        } else {
            this.authIdentity = null;
        }
        if (this.authIdentity != null) {
            options = options.withCallCredentials(new YdbCallCredentials(this.authIdentity));
        }
        if (transportBuilder.getCallExecutor() != null && transportBuilder.getCallExecutor() != MoreExecutors.directExecutor()) {
            options = options.withExecutor(transportBuilder.getCallExecutor());
        }
        if (transportBuilder.getGrpcCompression() != GrpcCompression.NO_COMPRESSION) {
            options = options.withCompression(transportBuilder.getGrpcCompression().compressor());
        }
        this.callOptions = options;
        this.readTimeoutMillis = transportBuilder.getReadTimeoutMillis();
    }

    @Override
    public void close() {
        if (this.authIdentity != null) {
            this.authIdentity.close();
        }
    }

    public String getToken() {
        if (this.authIdentity != null) {
            return this.authIdentity.getToken();
        }
        return null;
    }

    public CallOptions getGrpcCallOptions() {
        if (this.readTimeoutMillis > 0L) {
            return this.callOptions.withDeadlineAfter(this.readTimeoutMillis, TimeUnit.MILLISECONDS);
        }
        return this.callOptions;
    }
}

