/*
 * Decompiled with CFR 0.152.
 */
package tech.ydb.core.grpc;

import com.google.common.base.Preconditions;
import com.google.common.net.HostAndPort;
import com.google.common.util.concurrent.MoreExecutors;
import io.grpc.netty.shaded.io.grpc.netty.NettyChannelBuilder;
import java.time.Duration;
import java.util.Objects;
import java.util.concurrent.Executor;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import tech.ydb.auth.AuthRpcProvider;
import tech.ydb.auth.NopAuthProvider;
import tech.ydb.core.grpc.BalancingSettings;
import tech.ydb.core.grpc.GrpcCompression;
import tech.ydb.core.grpc.GrpcTransport;
import tech.ydb.core.impl.YdbSchedulerFactory;
import tech.ydb.core.impl.YdbTransportImpl;
import tech.ydb.core.impl.auth.GrpcAuthRpc;
import tech.ydb.core.utils.Version;

public class GrpcTransportBuilder {
    private final String endpoint;
    private final HostAndPort host;
    private final String database;
    private byte[] cert = null;
    private boolean useTLS = false;
    private Consumer<NettyChannelBuilder> channelInitializer = null;
    private Supplier<ScheduledExecutorService> schedulerFactory = YdbSchedulerFactory::createScheduler;
    private String localDc;
    private BalancingSettings balancingSettings;
    private Executor callExecutor = MoreExecutors.directExecutor();
    private AuthRpcProvider<? super GrpcAuthRpc> authProvider = NopAuthProvider.INSTANCE;
    private long readTimeoutMillis = 0L;
    private long connectTimeoutMillis = 30000L;
    private long discoveryTimeoutMillis = 60000L;
    private boolean useDefaultGrpcResolver = false;
    private GrpcCompression compression = GrpcCompression.NO_COMPRESSION;
    private boolean grpcRetry = false;

    GrpcTransportBuilder(@Nullable String endpoint, @Nullable HostAndPort host, @Nonnull String database) {
        this.endpoint = endpoint;
        this.host = host;
        this.database = Objects.requireNonNull(database);
        this.useTLS = endpoint != null && endpoint.startsWith("grpcs://");
    }

    @Nullable
    public HostAndPort getHost() {
        return this.host;
    }

    @Nullable
    public byte[] getCert() {
        return this.cert;
    }

    public boolean getUseTls() {
        return this.useTLS;
    }

    @Nullable
    public String getEndpoint() {
        return this.endpoint;
    }

    public String getDatabase() {
        return this.database;
    }

    public String getVersionString() {
        return Version.getVersion().map(version -> "ydb-java-sdk/" + version).orElse("unknown-version");
    }

    public Consumer<NettyChannelBuilder> getChannelInitializer() {
        return this.channelInitializer;
    }

    public Supplier<ScheduledExecutorService> getSchedulerFactory() {
        return this.schedulerFactory;
    }

    public String getLocalDc() {
        return this.localDc;
    }

    public BalancingSettings getBalancingSettings() {
        return this.balancingSettings;
    }

    public Executor getCallExecutor() {
        return this.callExecutor;
    }

    public AuthRpcProvider<? super GrpcAuthRpc> getAuthProvider() {
        return this.authProvider;
    }

    public long getReadTimeoutMillis() {
        return this.readTimeoutMillis;
    }

    public long getConnectTimeoutMillis() {
        return this.connectTimeoutMillis;
    }

    public long getDiscoveryTimeoutMillis() {
        return this.discoveryTimeoutMillis;
    }

    public GrpcCompression getGrpcCompression() {
        return this.compression;
    }

    public boolean isEnableRetry() {
        return this.grpcRetry;
    }

    public boolean useDefaultGrpcResolver() {
        return this.useDefaultGrpcResolver;
    }

    public GrpcTransportBuilder withChannelInitializer(Consumer<NettyChannelBuilder> channelInitializer) {
        this.channelInitializer = Objects.requireNonNull(channelInitializer, "channelInitializer is null");
        return this;
    }

    @Deprecated
    public GrpcTransportBuilder withLocalDataCenter(String dc) {
        this.localDc = dc;
        return this;
    }

    public GrpcTransportBuilder withSecureConnection(byte[] cert) {
        this.cert = (byte[])cert.clone();
        this.useTLS = true;
        return this;
    }

    public GrpcTransportBuilder withSecureConnection() {
        this.useTLS = true;
        return this;
    }

    public GrpcTransportBuilder withBalancingSettings(BalancingSettings balancingSettings) {
        this.balancingSettings = balancingSettings;
        return this;
    }

    public GrpcTransportBuilder withAuthProvider(AuthRpcProvider<? super GrpcAuthRpc> authProvider) {
        this.authProvider = Objects.requireNonNull(authProvider);
        return this;
    }

    public GrpcTransportBuilder withGrpcCompression(@Nonnull GrpcCompression compression) {
        this.compression = Objects.requireNonNull(compression, "compression is null");
        return this;
    }

    @Deprecated
    public GrpcTransportBuilder withReadTimeout(Duration timeout) {
        this.readTimeoutMillis = timeout.toMillis();
        Preconditions.checkArgument(this.readTimeoutMillis > 0L, "readTimeoutMillis must be greater than 0");
        return this;
    }

    @Deprecated
    public GrpcTransportBuilder withReadTimeout(long timeout, TimeUnit unit) {
        this.readTimeoutMillis = unit.toMillis(timeout);
        Preconditions.checkArgument(this.readTimeoutMillis > 0L, "readTimeoutMillis must be greater than 0");
        return this;
    }

    public GrpcTransportBuilder withConnectTimeout(Duration timeout) {
        this.connectTimeoutMillis = timeout.toMillis();
        Preconditions.checkArgument(this.connectTimeoutMillis > 0L, "connectTimeoutMillis must be greater than 0");
        return this;
    }

    public GrpcTransportBuilder withConnectTimeout(long timeout, TimeUnit unit) {
        this.connectTimeoutMillis = unit.toMillis(timeout);
        Preconditions.checkArgument(this.connectTimeoutMillis > 0L, "connectTimeoutMillis must be greater than 0");
        return this;
    }

    public GrpcTransportBuilder withDiscoveryTimeout(Duration timeout) {
        this.discoveryTimeoutMillis = timeout.toMillis();
        Preconditions.checkArgument(this.discoveryTimeoutMillis > 0L, "discoveryTimeoutMillis must be greater than 0");
        return this;
    }

    public GrpcTransportBuilder withDiscoveryTimeout(long timeout, TimeUnit unit) {
        this.discoveryTimeoutMillis = unit.toMillis(timeout);
        Preconditions.checkArgument(this.discoveryTimeoutMillis > 0L, "discoveryTimeoutMillis must be greater than 0");
        return this;
    }

    public GrpcTransportBuilder withCallExecutor(Executor executor) {
        this.callExecutor = Objects.requireNonNull(executor);
        return this;
    }

    public GrpcTransportBuilder withGrpcRetry(boolean enabled) {
        this.grpcRetry = enabled;
        return this;
    }

    public GrpcTransportBuilder withUseDefaultGrpcResolver(boolean use) {
        this.useDefaultGrpcResolver = use;
        return this;
    }

    public GrpcTransportBuilder withSchedulerFactory(Supplier<ScheduledExecutorService> factory) {
        this.schedulerFactory = Objects.requireNonNull(factory, "schedulerFactory is null");
        return this;
    }

    @Deprecated
    public GrpcTransportBuilder enableRetry() {
        this.grpcRetry = true;
        return this;
    }

    @Deprecated
    public GrpcTransportBuilder disableRetry() {
        this.grpcRetry = false;
        return this;
    }

    public GrpcTransport build() {
        YdbTransportImpl impl = new YdbTransportImpl(this);
        try {
            impl.init();
            return impl;
        }
        catch (RuntimeException ex) {
            impl.close();
            throw ex;
        }
    }

    public GrpcTransport buildAsync(Runnable ready) {
        YdbTransportImpl impl = new YdbTransportImpl(this);
        impl.initAsync(ready);
        return impl;
    }
}

