/*
 * Decompiled with CFR 0.152.
 */
package tech.ydb.core.grpc;

import io.grpc.Metadata;
import java.time.Duration;
import java.util.function.Consumer;

public class GrpcRequestSettings {
    private final long deadlineAfter;
    private final Integer preferredNodeID;
    private final Metadata extraHeaders;
    private final Consumer<Metadata> trailersHandler;

    private GrpcRequestSettings(Builder builder) {
        this.deadlineAfter = builder.getDeadlineAfter();
        this.preferredNodeID = builder.getPreferredNodeID();
        this.extraHeaders = builder.getExtraHeaders();
        this.trailersHandler = builder.getTrailersHandler();
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public long getDeadlineAfter() {
        return this.deadlineAfter;
    }

    public Integer getPreferredNodeID() {
        return this.preferredNodeID;
    }

    public Metadata getExtraHeaders() {
        return this.extraHeaders;
    }

    public Consumer<Metadata> getTrailersHandler() {
        return this.trailersHandler;
    }

    public static final class Builder {
        private long deadlineAfter = 0L;
        private Integer preferredNodeID = null;
        private Metadata extraHeaders = null;
        private Consumer<Metadata> trailersHandler = null;

        public Builder withDeadlineAfter(long deadlineAfter) {
            this.deadlineAfter = deadlineAfter;
            return this;
        }

        public Builder withDeadline(Duration duration) {
            this.deadlineAfter = duration != null && !duration.isZero() ? System.nanoTime() + duration.toNanos() : 0L;
            return this;
        }

        public Builder withPreferredNodeID(Integer preferredNodeID) {
            this.preferredNodeID = preferredNodeID;
            return this;
        }

        public Builder withExtraHeaders(Metadata headers) {
            this.extraHeaders = headers;
            return this;
        }

        public Builder withTrailersHandler(Consumer<Metadata> handler) {
            this.trailersHandler = handler;
            return this;
        }

        public long getDeadlineAfter() {
            return this.deadlineAfter;
        }

        public Integer getPreferredNodeID() {
            return this.preferredNodeID;
        }

        public Metadata getExtraHeaders() {
            return this.extraHeaders;
        }

        public Consumer<Metadata> getTrailersHandler() {
            return this.trailersHandler;
        }

        public GrpcRequestSettings build() {
            return new GrpcRequestSettings(this);
        }
    }
}

